% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelW_C.R
\name{kernelW_C}
\alias{kernelW_C}
\title{Computes weight matrix for a given kernel and bandwidth}
\usage{
kernelW_C(XX, hh, MykernelS, isgcv_, Type, Minv, maxknn_,
NmaxDist_, TIME, Decay, DDiagNull)
}
\arguments{
\item{XX}{a matrix with coordinates.}

\item{hh}{a bandwidth value}

\item{MykernelS}{a kernel type between ('bin','bisq','gauss','gauss_adapt',
'knn',bisq_knn')}

\item{isgcv_}{default FALSE for computing CV criteria (for example for selecting optimal bandwidth).}

\item{Type}{Kernel type.}

\item{Minv, }{minimum number of neighbors when using distance kernels.}

\item{maxknn_}{default 500, when n>NmaxDist only  maxknn first neighbours are used for computation distance}

\item{NmaxDist_}{default 5000, when n>NmaxDist only  maxknn first neighbours are used for computing distance}

\item{TIME}{default FALSE, time is used for computing weigths if TIME is TRUE
weigth for future observation are set to zero}

\item{Decay}{time decay when time is used for computing weigths.}

\item{DDiagNull}{default FALSE, if TRUE diagonal has zero weights.}
}
\value{
kernelW_C returns a sparse weight matrix
}
\description{
kernelW_C is a function that computes weight matrix for a given kernel and bandwidth
}
\examples{
\donttest{
data(data_mgwrsar);coord=as.matrix(mydata[,c("x_lat","y_lon")]);
W=kernelW_C(coord,100,'bisq_knn',FALSE,'GD',1,500,5000,FALSE,0,FALSE)
plot(D_dense_C(coord[1,1],coord[1,2],coord[,1],coord[,2]),W[1,])
}
}
\seealso{
MGWRSAR, bandwidths_mgwrsar, summary_mgwrsar, plot_mgwrsar, predict_mgwrsar
}
