% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{mgc.sims.step}
\alias{mgc.sims.step}
\title{Step Function Simulation}
\usage{
mgc.sims.step(n, d, eps = 1, ind = FALSE, a = -1, b = 1)
}
\arguments{
\item{n}{the number of samples for the simulation.}

\item{d}{the number of dimensions for the simulation setting.}

\item{eps}{the noise level for the simulation. Defaults to \code{1}.}

\item{ind}{whether to sample x and y independently. Defaults to \code{FALSE}.}

\item{a}{the lower limit for the data matrix. Defaults to \code{-1}.}

\item{b}{the upper limit for the data matrix. Defaults to \code{-1}.}
}
\value{
a list containing the following:
\item{\code{X}}{\code{[n, d]} the data matrix with \code{n} samples in \code{d} dimensions.}
\item{\code{Y}}{\code{[n]} the response array.}
}
\description{
A function for Generating a step function simulation.
}
\section{Details}{

Given: \eqn{w_i = \frac{1}{i}}{w[i] = 1/i} is a weight-vector that scales with the dimensionality.
Simulates \eqn{n} points from \eqn{Step-Function(X, Y) \in \mathbf{R}^d\times \mathbf{R}}{Step-Function(X, Y)} where:
\deqn{X \sim {U}\left(a, b\right)^d}{X ~ U(a, b)^d},
\deqn{Y = \mathbf{I}\left\{w^TX > 0\right\} + \kappa \epsilon N(0, 1)}{Y = I{w^TX > 0} + K*eps*N(0, 1)}
and \eqn{\kappa = 1\textrm{ if }d = 1, \textrm{ and 0 otherwise}}{K = 1 if d=1, and 0 otherwise} controls the noise for higher dimensions.
}

\examples{
library(mgc)
result  <- mgc.sims.step(n=100, d=10)  # simulate 100 samples in 10 dimensions
X <- result$X; Y <- result$Y
}
\author{
Eric Bridgeford
}
