% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landmarking.R
\name{mf.landmarking}
\alias{mf.landmarking}
\alias{mf.landmarking.default}
\alias{mf.landmarking.formula}
\title{Landmarking Meta-features}
\usage{
mf.landmarking(...)

\method{mf.landmarking}{default}(x, y, features = "all", summary = c("mean",
  "sd"), map = c("one.vs.all", "one.vs.one"), folds = 10, ...)

\method{mf.landmarking}{formula}(formula, data, features = "all",
  summary = c("mean", "sd"), map = c("one.vs.all", "one.vs.one"),
  folds = 10, ...)
}
\arguments{
\item{...}{Optional arguments to the summary methods.}

\item{x}{A data.frame contained only the input attributes}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.}

\item{summary}{A list of methods to summarize the results as post-processing
functions. See \link{post.processing} method to more information. (Default:
\code{c("mean", "sd")})}

\item{map}{A list of decomposition strategies for multi-class problems. The
options are \code{"one.vs.all"} and \code{"one.vs.one"} strategy.}

\item{folds}{The number of k equal size subsamples in k-fold
cross-validation.}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class.
The details section describes the valid values for this group.}
}
\value{
Each one of these meta-features generate multiple values (by fold
 and/or attribute) and then it is post processed by the summary methods.
 See the \link{post.processing} method for more details about it.
}
\description{
Landmarking meta-features include the performance of some simple and
efficient learning algorithms.
}
\details{
The following features are allowed for this method:
 \describe{
   \item{"decision.stumps"}{Represents the performance of a single node DT
     model induced by the most informative attribute.}
   \item{"elite.nearest.neighbor"}{Represents the performance of the Elite
     1-Nearest Neighbor classifier.}
   \item{"linear.discriminant"}{Represents the performance of the Linear
     Discriminant classifier.}
   \item{"naive.bayes"}{Represents the performance of the Naive Bayes
     classifier.}
   \item{"nearest.neighbor"}{Represents the performance of the 1-Nearest
     Neighbor classifier.}
   \item{"worst.node"}{Represents the performance of a single node DT
     model induced by the less informative attribute.}
 }
}
\examples{
## Extract all meta-features using formula
mf.landmarking(Species ~ ., iris)

## Extract all meta-features using data.frame
mf.landmarking(iris[1:4], iris[5])

## Extract some meta-features
mf.landmarking(Species ~ ., iris, features=c("decision.stumps",
"nearest.neighbor", "linear.discriminant"))

## Extract all meta-features with different summary methods
mf.landmarking(Species ~ ., iris, summary=c("min", "median", "max"))
}
\references{
Pfahringer, B., Bensusan, H., &  Giraud-Carrier, C. G. (2000). Meta-Learning
 by Landmarking Various Learning Algorithms. In Proceedings of the 17th
 International Conference on Machine Learning (pp. 743-750)
}
\seealso{
Other meta.features: \code{\link{mf.discriminant}},
  \code{\link{mf.general}}, \code{\link{mf.infotheo}},
  \code{\link{mf.model.based}},
  \code{\link{mf.statistical}}
}

