% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{plot.mfbvar_ss}
\alias{plot.mfbvar_ss}
\title{Plotting method for class \code{mfbvar_ss}}
\usage{
\method{plot}{mfbvar_ss}(x, plot_start = NULL, ss_level = c(0.025,
  0.975), pred_level = c(0.1, 0.9), nrow_facet = NULL, ...)
}
\arguments{
\item{x}{object of class \code{mfbvar_ss}}

\item{plot_start}{Time period (number) to start plotting from. Default is to to use \code{5*n_fcst} time periods if \code{n_fcst} exists, otherwise the entire sample.}

\item{ss_level}{A vector with the lower and upper quantiles for the posterior steady-state intervals.}

\item{pred_level}{A vector with the lower and upper quantiles for the forecast intervals.}

\item{nrow_facet}{an integer giving the number of rows to use in the facet}

\item{...}{Currently not in use.}
}
\description{
Method for plotting \code{mfbvar_ss} objects.
}
\examples{
prior_obj <- set_prior(Y = mf_sweden[, 4:5], d = "intercept",
                       freq = c("m", "q"), n_lags = 4, n_burnin = 20, n_reps = 20,
                       n_fcst = 4)

prior_intervals <- matrix(c(-0.1, 0.1,
                            0.4, 0.6), ncol = 2, byrow = TRUE)
psi_moments <- interval_to_moments(prior_intervals)
prior_psi_mean <- psi_moments$prior_psi_mean
prior_psi_Omega <- psi_moments$prior_psi_Omega
prior_obj <- update_prior(prior_obj,
                          prior_psi_mean = prior_psi_mean,
                          prior_psi_Omega = prior_psi_Omega)

mod_ss <- estimate_mfbvar(prior_obj, prior_type = "ss")
plot(mod_ss)
}
