% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{schlather.vario}
\alias{schlather.vario}
\title{Variogram model of Schlather and Moreva}
\usage{
schlather.vario(h, alpha, beta, scale = 1)
}
\arguments{
\item{h}{vector or matrix of pairwise distances}

\item{alpha}{smoothness parameter}

\item{beta}{shape parameter, must be less than 2}

\item{scale}{scale parameter}
}
\value{
a vector or matrix of variogram values of the same length as \code{h}
}
\description{
The variogram model is
\deqn{\gamma(h) = \frac{[1+\{(\|h\|/\lambda\}^\alpha]^{\beta/\alpha}-1}{2^{\beta/\alpha}-1}, \quad 0 < \alpha \leq 2, \beta \leq 2.}
The model is defined at \eqn{\beta=0} by continuity.
}
\keyword{internal}
