% Generated by roxygen2 (4.0.0): do not edit by hand
\name{blocksample}
\alias{blocksample}
\title{Block sampling}
\usage{
blocksample(data, size, idvar = "id", replace = TRUE, ...)
}
\arguments{
\item{data}{Data frame}

\item{idvar}{Column defining the clusters}

\item{size}{Size of samples}

\item{replace}{Logical indicating wether to sample with replacement}

\item{\dots}{additional arguments to lower level functions}
}
\value{
\code{data.frame}
}
\description{
Sample blockwise from clustered data
}
\examples{
d <- data.frame(x=rnorm(5), z=rnorm(5), id=c(4,10,10,5,5), v=rnorm(5))
(dd <- blocksample(d,size=20))
attributes(dd)$id

\dontrun{
blocksample(data.table::data.table(d),1e6)
}
}
\author{
Klaus K. Holst
}
\keyword{models}
\keyword{utilities}

