% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/metricsgraphics.R
\name{mjs_line}
\alias{mjs_line}
\title{metricsgraphics.js linechart "geom"}
\usage{
mjs_line(mjs, area = FALSE, animate_on_load = FALSE,
  interpolate = "cardinal")
}
\arguments{
\item{mjs}{plot object}

\item{area}{fill in area under line? (default: \code{FALSE} - no)}

\item{animate_on_load}{animate the drawing of the plot on page load? (default: \code{FALSE} - no)}

\item{interpolate}{the interpolation function to use when rendering lines.
possible values: ("cardinal", "linear", "linear-closed", "step", "step-before",
"step-after", "basis", "basis-open", "basis-closed", "bundle", "cardinal-open",
"cardinal-closed", "monotone", "basic")}
}
\value{
metricsgraphics object
}
\description{
This function adds a line "geom" to a metricsgraphics.js html widget.
}
\examples{
data.frame(year=seq(1790, 1970, 10),
           uspop=as.numeric(uspop)) \%>\%
  mjs_plot(x=year, y=uspop) \%>\%
  mjs_line()
}

