% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBE.R
\name{MBE}
\alias{MBE}
\title{Mean Bias Error (MBE)}
\usage{
MBE(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
}
\description{
It estimates the MBE for a continuous predicted-observed dataset.
}
\details{
The MBE is one of the most widely used error metrics. It presents the same units
than the response variable, and it is unbounded. It can be simply estimated as the difference between
the means of predictions and observations. The closer to zero the better. Negative values indicate overestimation.
Positive values indicate general underestimation. The disadvantage is that is only sensitive to additional bias.
As a disadvantage, the MBE may mask a poor performance if overestimation and underestimation co-exist (a type of proportional bias).
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
MBE(obs = X, pred = Y)
}
}
