% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAE.R
\name{MAE}
\alias{MAE}
\title{Mean Absolute Error (MAE)}
\usage{
MAE(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
}
\description{
It estimates the MAE for a continuous predicted-observed dataset.
}
\details{
The MAE measures both lack of accuracy and precision in absolute scale.
It keeps the same units than the response variable. It is less sensitive to outliers
than the MSE or RMSE. The lower the better.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
MAE(obs = X, pred = Y)
}
}
\references{
Willmott & Matsuura (2005).
Advantages of the mean absolute error (MAE) over the root mean square error (RMSE) in assessing average model performance.
\emph{Clim. Res. 30, 79–82.} \doi{10.3354/cr030079}
}
