% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_summary_interpolated_data.R
\name{summarise_interpolated_data}
\alias{summarise_interpolated_data}
\title{Summarise interpolated data by temporal dimension}
\usage{
summarise_interpolated_data(
  interpolated_data,
  fun = "mean",
  frequency = NULL,
  vars_to_summary = c("MeanTemperature", "MinTemperature", "MaxTemperature",
    "Precipitation", "MeanRelativeHumidity", "MinRelativeHumidity",
    "MaxRelativeHumidity", "Radiation", "WindSpeed", "WindDirection", "PET"),
  dates_to_summary = NULL,
  months_to_summary = 1:12,
  verbose = getOption("meteoland_verbosity", TRUE),
  ...
)
}
\arguments{
\item{interpolated_data}{An interpolated data object as returned by
\code{\link{interpolate_data}}.}

\item{fun}{The function to use for summarising the data.}

\item{frequency}{A string indicating the interval specification (allowed ones
are "week", "month", "quarter" and "year"). If NULL (default), aggregation
is done in one interval for all the dates present.}

\item{vars_to_summary}{A character vector with one or more variable names to
summarise. By default, all interpolated variables are summarised.}

\item{dates_to_summary}{A Date object to define the dates to be summarised.
If NULL (default), all dates in the interpolated data are processed.}

\item{months_to_summary}{A numeric vector with the month numbers to subset
the data before summarising. (e.g. \code{c(7,8)} for July and August).
This parameter allows studying particular seasons, when combined with
\code{frequency}. For example \code{frequency = "years"} and
\code{months = 6:8} leads to summarizing summer months of each year.}

\item{verbose}{Logical indicating if the function must show messages and info.
Default value checks \code{"meteoland_verbosity"} option and if not set, defaults
to TRUE. It can be turned off for the function with FALSE, or session wide with
\code{options(meteoland_verbosity = FALSE)}}

\item{...}{Arguments needed for \code{fun}}
}
\value{
For a nested interpolated data, the same sf object with a new column
with the temporal summaries. For an unnested interpolated
data, a data.frame with the summarised meteo variables. For an interpolated
raster (stars object), the same raster with the temporal dimension aggregated
as desired.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Summarises the interpolated meteorology in one or more locations by the desired
temporal scale
}
\details{
If \code{interpolated_data} is a nested interpolated data sf object, as
returned by \code{\link{interpolate_data}}, temporal summary is done for each
location present in the interpolated data. If \code{interpolated_data} is
an unnested interpolated data sf object, temporal summary is done for all
locations together. If \code{interpolated_data} is a single location data.frame
containing the dates and the interpolated variables, temporal summary is done
for that location. If \code{interpolated_data} is a stars object as returned
by \code{\link{interpolate_data}}, temporal summary is done for all the raster.
}
\examples{
\donttest{
# points interpolation aggregation
points_to_interpolate_example |>
  interpolate_data(meteoland_interpolator_example, verbose = FALSE) |>
  summarise_interpolated_data()

# raster interpolation aggregation
raster_to_interpolate_example |>
  interpolate_data(meteoland_interpolator_example, verbose = FALSE) |>
  summarise_interpolated_data()
}

}
\author{
\enc{Víctor}{Victor} Granda \enc{García}{Garcia}, CREAF
}
