% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/meteSSF.R
\name{metePi}
\alias{metePi}
\title{Equation of the PMF of the METE spatial species abundance distribution}
\usage{
metePi(n, la, n0)
}
\arguments{
\item{n}{A vector giving abundances of each entry}

\item{la}{The spatial Lagrange multiplier returned by \code{meteSSF}}

\item{n0}{Total abundance in area A0}
}
\value{
a numeric vector giving the probability of each entry in \code{n}
}
\description{
\code{metePi} is a low level function that returns the spatial species abundance
distribution \eqn{Pi(n)} predicted by METE; vectorized in n
}
\details{
See Examples
}
\examples{
metePi(0:10, 0.01, 100)
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
metePi
}

