% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_from_derived}
\alias{build_from_derived}
\title{Build a dataset from derived}
\usage{
build_from_derived(
  metacore,
  ds_list,
  dataset_name = NULL,
  predecessor_only = TRUE,
  keep = FALSE
)
}
\arguments{
\item{metacore}{metacore object that contains the specifications for the
dataset of interest.}

\item{ds_list}{Named list of datasets that are needed to build the from}

\item{dataset_name}{Optional string to specify the dataset that is being
built. This is only needed if the metacore object provided hasn't already
been subsetted.}

\item{predecessor_only}{By default `FALSE`, but if `TRUE` will only use
derivations with the origin of 'Predecessor'}

\item{keep}{Boolean to determine if the original columns should be kept. By
default `FALSE`, so only the ADaM columns are kept. If `TRUE` the resulting
dataset will have all the ADaM columns as well as any SDTM column that were
renamed in the ADaM (i.e `ARM` and `TRT01P` will be in the resulting
dataset)}
}
\value{
dataset
}
\description{
This function builds a dataset out of the columns that just need to be pulled
through. So any variable that has a derivation in the format of
'dataset.variable' will be pulled through to create the new dataset. When
there are multiple datasets present, they will be joined by the shared
`key_seq` variables. These columns are often called 'Predecessors' in ADaM,
but this is not universal so that is optional to specify.
}
\examples{
library(metacore)
library(haven)
library(magrittr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
ds_list <- list(DM = read_xpt(metatools_example("dm.xpt")))
build_from_derived(spec, ds_list, predecessor_only = FALSE)
}
