% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_list.R
\name{dlapply}
\alias{dlapply}
\title{Apply-like function for data list objects}
\usage{
dlapply(X, FUN, ...)
}
\arguments{
\item{X}{A \code{data_list} class object.}

\item{FUN}{The function to be applied to each data list component.}

\item{...}{Optional arguments to \code{FUN}.}
}
\value{
If FUN applied to each component of X yields a valid data list, a
data list. Otherwise, a list.
}
\description{
This function enables manipulating a \code{data_list} class object with lapply
syntax without removing that object's \code{data_list} class attribute. The
function will only preserve this attribute if the result of the apply call
has a valid data list structure.
}
\examples{
# Convert all UID values to lowercase
dl <- data_list(
    list(abcd_income, "income", "demographics", "discrete"),
    list(abcd_colour, "colour", "likes", "categorical"),
    uid = "patient"
)

dl_lower <- dlapply(
    dl,
    function(x) {
        x$"data"$"uid" <- tolower(x$"data"$"uid")
        return(x)
    }
)
}
