% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtsi.R
\name{plot.mtsi}
\alias{plot.mtsi}
\title{Plot the multi-trait stability index}
\usage{
\method{plot}{mtsi}(
  x,
  SI = 15,
  type = "index",
  position = "fill",
  genotypes = "selected",
  radar = TRUE,
  arrange.label = FALSE,
  x.lab = NULL,
  y.lab = NULL,
  size.point = 2.5,
  size.line = 0.7,
  size.text = 10,
  width.bar = 0.75,
  n.dodge = 1,
  check.overlap = FALSE,
  invert = FALSE,
  col.sel = "red",
  col.nonsel = "black",
  ...
)
}
\arguments{
\item{x}{An object of class \code{mtsi}}

\item{SI}{An integer [0-100]. The selection intensity in percentage of the
total number of genotypes.}

\item{type}{The type of the plot. Defaults to \code{"index"}. Use \code{type
= "contribution"} to show the contribution of each factor to the MGIDI
index of the selected genotypes.}

\item{position}{The position adjustment when \code{type = "contribution"}.
Defaults to \code{"fill"}, which shows relative proportions at each trait
by stacking the bars and then standardizing each bar to have the same
height. Use \code{position = "stack"} to plot the MGIDI index for each
genotype.}

\item{genotypes}{When \code{type = "contribution"} defines the genotypes to
be shown in the plot. By default (\code{genotypes = "selected"} only
selected genotypes are shown. Use \code{genotypes = "all"} to plot the
contribution for all genotypes.)}

\item{radar}{Logical argument. If true (default) a radar plot is generated
after using \code{coord_polar()}.}

\item{arrange.label}{Logical argument. If \code{TRUE}, the labels are
arranged to avoid text overlapping. This becomes useful when the number of
genotypes is large, say, more than 30.}

\item{x.lab, y.lab}{The labels for the axes x and y, respectively. x label is
set to null when a radar plot is produced.}

\item{size.point}{The size of the point in graphic. Defaults to 2.5.}

\item{size.line}{The size of the line in graphic. Defaults to 0.7.}

\item{size.text}{The size for the text in the plot. Defaults to 10.}

\item{width.bar}{The width of the bars if \code{type = "contribution"}.
Defaults to 0.75.}

\item{n.dodge}{The number of rows that should be used to render the x labels.
This is useful for displaying labels that would otherwise overlap.}

\item{check.overlap}{Silently remove overlapping labels, (recursively)
prioritizing the first, last, and middle labels.}

\item{invert}{Logical argument. If \code{TRUE}, rotate the plot.}

\item{col.sel}{The colour for selected genotypes. Defaults to \code{"red"}.}

\item{col.nonsel}{The colour for nonselected genotypes. Defaults to \code{"black"}.}

\item{...}{Other arguments to be passed from ggplot2::theme().}
}
\value{
An object of class \code{gg, ggplot}.
}
\description{
Makes a radar plot showing the multitrait stability index proposed by Olivoto
et al. (2019)
}
\examples{
\donttest{
library(metan)
mtsi_model <- waasb(data_ge, ENV, GEN, REP, resp = c(GY, HM))
mtsi_index <- mtsi(mtsi_model)
plot(mtsi_index)
}


}
\references{
Olivoto, T., A.D.C. L{\'{u}}cio, J.A.G. da silva, B.G. Sari, and M.I. Diel. 2019. Mean performance and stability in multi-environment trials II: Selection based on multiple traits. Agron. J. (in press).
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
