% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ammi_indexes.R
\name{print.ammi_indexes}
\alias{print.ammi_indexes}
\title{Print an object of class ammi_indexes}
\usage{
\method{print}{ammi_indexes}(x, which = "stats", export = FALSE, file.name = NULL, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{ammi_indexes}.}

\item{which}{Which should be printed. Defaults to \code{"stats"}. Other
possible values are \code{"ranks"} for genotype ranking and \code{"ssi"}
for the simultaneous selection index.}

\item{export}{A logical argument. If \code{TRUE}, a *.txt file is exported to
the working directory.}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print the \code{ammi_indexes} object in two ways. By default, the results are shown
in the R console. The results can also be exported to the directory into a
*.txt file.
}
\examples{
\donttest{
library(metan)
model <- performs_ammi(data_ge, ENV, GEN, REP, GY) \%>\%
         ammi_indexes()
print(model)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
