% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_eigen.R
\name{plot_eigen}
\alias{plot_eigen}
\title{Plot the eigenvalues}
\usage{
plot_eigen(
  x,
  var = 1,
  export = FALSE,
  plot_theme = theme_metan(),
  file.type = "pdf",
  file.name = NULL,
  width = 6,
  height = 6,
  size.shape = 3.5,
  size.line = 1,
  size.tex.lab = 12,
  y.lab = "Eigenvalue",
  y2.lab = "Accumulated variance",
  x.lab = "Number of multiplicative terms",
  resolution = 300,
  ...
)
}
\arguments{
\item{x}{The \verb{waasb object}}

\item{var}{The variable to plot. Defaults to \code{var = 1} the first
variable of \code{x}.}

\item{export}{Export (or not) the plot. Default is \code{TRUE}.}

\item{plot_theme}{The graphical theme of the plot. Default is
\code{plot_theme = theme_metan()}. For more details, see
\code{\link[ggplot2:theme]{ggplot2::theme()}}.}

\item{file.type}{If \code{export = TRUE}, define the type of file to be
exported. Default is \code{pdf}, Graphic can also be exported in
\verb{*.tiff} format by declaring \code{file.type = "tiff"}.}

\item{file.name}{The name of the file for exportation, default is
\code{NULL}, i.e. the files are automatically named.}

\item{width}{The width "inch" of the plot. Default is \code{6}.}

\item{height}{The height "inch" of the plot. Default is \code{6}.}

\item{size.shape}{The size of the shape. Default is \code{3.5}.}

\item{size.line}{The size of the line. Default is \code{1}.}

\item{size.tex.lab}{The size of the text in axis text and labels.}

\item{y.lab}{The label of the y-axis in the plot. Default is
\code{"Eigenvalue"}.}

\item{y2.lab}{The label of the second y-axis in the plot. Default is
\code{"Accumulated variance"}.}

\item{x.lab}{The label of the x-axis in the plot. Default is \code{"Number of multiplicative terms"}.}

\item{resolution}{The resolution of the plot. Parameter valid if
\code{file.type = "tiff"} is used. Default is \code{300} (300 dpi)}

\item{...}{Currently not used.}
}
\value{
An object of class \verb{gg, ggplot}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Plot the eigenvalues for from singular value decomposition of BLUP
interaction effects matrix.
}
\examples{
\donttest{
library(metan)
BLUP <- waasb(data_ge,
             resp = c(GY, HM),
             gen = GEN,
             env = ENV,
             rep = REP)
plot_eigen(BLUP)

}

}
\seealso{
\code{\link[=plot_scores]{plot_scores()}}, \code{\link[=plot_waasby]{plot_waasby()}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
