% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gai.R
\name{gai}
\alias{gai}
\title{Geometric adaptability index}
\usage{
gai(.data, env, gen, rep = "deprecated", resp, verbose = TRUE)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes, replication/block and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{rep}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure use, for example, \code{resp = c(var1, var2, var3)}.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code will run
silently.}
}
\value{
An object of class \code{gai}, which is a list containing the results
for each variable used in the argument \code{resp}. For each variable, a
tibble with the following columns is returned.
\itemize{
\item \strong{GEN} the genotype's code.
\item \strong{GAI} Geometric adaptability index
\item \strong{GAI_R} The rank for the GAI value.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Performs a stability analysis based on the geometric mean (GAI), according to
the following model (Mohammadi and Amri, 2008):
\loadmathjax
\mjsdeqn{GAI = \sqrt[E]{{\mathop {\bar Y}\nolimits_1  + \mathop {\bar Y}\nolimits_2  + ... + \mathop {\bar Y}\nolimits_i }}}
where \mjseqn{\bar Y_1}, \mjseqn{\bar Y_2}, and \mjseqn{\bar Y_i} are
the mean yields of the first, second and \emph{i}-th genotypes across
environments, and E is the number of environments
}
\examples{
\donttest{
library(metan)
out <- gai(data_ge2, ENV, GEN, REP, c(EH, PH, EL, CD, ED, NKE))
}

}
\references{
Mohammadi, R., & Amri, A. (2008). Comparison of parametric and non-parametric
methods for selecting stable and adapted durum wheat genotypes in variable
environments. Euphytica, 159(3), 419-432.
\doi{10.1007/s10681-007-9600-6}.
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
