% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgidi.R
\name{print.mgidi}
\alias{print.mgidi}
\title{Print an object of class mgidi
Print a \code{mgidi} object in two ways. By default, the results are shown in
the R console. The results can also be exported to the directory.}
\usage{
\method{print}{mgidi}(x, export = FALSE, file.name = NULL, digits = 4, ...)
}
\arguments{
\item{x}{An object of class \code{mgidi}.}

\item{export}{A logical argument. If \code{TRUE|T}, a *.txt file is exported
to the working directory}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print an object of class mgidi
Print a \code{mgidi} object in two ways. By default, the results are shown in
the R console. The results can also be exported to the directory.
}
\examples{
\donttest{
library(metan)
model <- gamem(data_g,
               gen = GEN,
               rep = REP,
               resp = c(KW, NR, NKE, NKR))
mgidi_index <- mgidi(model)
print(mgidi_index)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
