% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/or2rr.R
\name{or2rr}
\alias{or2rr}
\title{Calculate risk ratios from odds ratios and baseline risk}
\usage{
or2rr(or, br)
}
\arguments{
\item{or}{Odds ratio(s).}

\item{br}{Baseline risk (also known as assumed comparator risk),
i.e., risk that the outcome of interest would occur in the comparator 
intervention. It must be expressed as a value between 0 and 1.}
}
\value{
A vector or matrix with risk ratios.
}
\description{
Calculate risk ratios from odds ratios and baseline risk.
}
\details{
Converts odds ratios (OR) into risk ratios (RR) using the
formula available in Schunemann et al. (2019), Chapter 15:

RR = OR / (1 - br x (1 - OR)),

with br corresponding to the baseline risk (the assumed comparator risk;
i.e., the risk that the outcome of interest would occur in the comparison
intervention).
}
\examples{
data(anticoagulation)
RRs <- or2rr(anticoagulation, br = 0.5)
head(RRs)

}
\references{
Schunemann HJ, Vist GE, Higgins JPT, et al. (2019).
\dQuote{Interpreting results and drawing conclusions.}
\emph{Cochrane Handbook for Systematic Reviews of Interventions},
403--431.
}
\author{
Bernardo Sousa-Pinto \email{bernardo@med.up.pt},
  Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
