% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/figure_detectAxis.R
\name{figure_detectAxis}
\alias{figure_detectAxis}
\title{Detect an axis from a figure image.}
\usage{
figure_detectAxis(aBinaryPlot, axis_type = "X", axis_thickness = 5,
  sensitivity = 0.2)
}
\arguments{
\item{aBinaryPlot}{A binary figure image (an EBImage object).
See: \code{\link{figure_transformToBinary}}}

\item{axis_type}{The axis to be detected from a figure: can
be \code{X} or \code{Y}.}

\item{axis_thickness}{An integer used to designate the thickness of the
axis lines on a figure.  Close alignment to the thickness of the axis
on a figure will improve axis detection.}

\item{sensitivity}{A value designating the sensitivity of identifying
   straight lines on a figure.  A smaller number results in a higher
   sensitivity to identify axes.}
}
\value{
An \code{EBImage} object with detected points.
}
\description{
Attempts to detect either the X (horizontal) or Y (vertical) axis from
a plotted figure.
}
\seealso{
\link{figure_detectAllPoints}
}

