% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PartialDependence.R
\name{PartialDependence}
\alias{PartialDependence}
\title{Plots partial dependence plots for a MetaForest object, using the function
\code{partial_dependence()} from the package \code{edarf}.}
\usage{
PartialDependence(mf, vars = NULL, interaction = FALSE, ...)
}
\arguments{
\item{mf}{MetaForest object.}

\item{vars}{Character vector containing the moderator names for which to plot
partial dependence plots. If empty, all moderators are plotted.}

\item{interaction}{Logical, indicating whether a bivariate interaction should
be plotted, using a heatmap. Only valid when the number of \code{vars} is 2.}

\item{...}{Additional arguments to be passed to \code{partial_dependence}.}
}
\value{
A ggplot object.
}
\description{
Plots partial dependence plots for a MetaForest object, using the function
\code{partial_dependence()} from the package \code{edarf}.
}
\examples{
set.seed(42)
data <- SimulateSMD(k_train = 100, model = es * x[, 1] + es * x[, 2] + es *
                                           x[, 1] * x[, 2])
mf.random <- MetaForest(formula = yi ~ ., data = data$training,
                        whichweights = "random", method = "DL",
                        tau2 = 0.2450)
#Examine univariate partial dependence plot for all variables in the model:
PartialDependence(mf.random)
#Examine bivariate partial dependence plot the interaction between X1 and X2:
PartialDependence(mf.random, vars = c("X1", "X2"), interaction = TRUE)
}
