% Generated by roxygen2 (4.0.1): do not edit by hand
\name{metasim_base}
\alias{metasim_base}
\title{Base-level metapopulation simulation function}
\usage{
metasim_base(n_pop, n_t, spawners_0, b, epsilon_mat, A_params, add_straying,
  stray_mat, assess_years, r_escp_goals, sigma_impl, add_impl_error, decrease_b,
  debug)
}
\arguments{
  \item{n_t}{The number of years.}

  \item{n_pop}{Number of populations}

  \item{spawners_0}{A vector of spawner abundances at the
  start of the simulation. Length of the vector should
  equal the number of populations.}

  \item{b}{Ricker density-dependent parameter. A vector
  with one numeric value per population.}

  \item{epsilon_mat}{A matrix of recruitment deviations.}

  \item{A_params}{A matrix of Ricker a parameters}

  \item{add_straying}{Implement straying between
  populations?}

  \item{stray_mat}{A straying matrix.}

  \item{assess_years}{A vector of years to assess a and b
  in}

  \item{r_escp_goals}{A matrix of escapement goals.}

  \item{sigma_impl}{Implementation standard deviation for
  the implementation error beta distribution.}

  \item{add_impl_error}{Add implementation error?
  Implementation error is derived using
  \code{\link{impl_error}}.}

  \item{decrease_b}{A numeric value to decrease all streams
  by each generation. This is intended to be used to
  simulate habitat loss, for example though stream flow
  reduction with climate change.}

  \item{debug}{Boolean. Should some debuging messages be
  turned on?}
}
\description{
This is an Rcpp implementation of the main simulation. It
is meant to be called by \code{\link{meta_sim}}.
}

