% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_silico_pcr.R
\name{run_primersearch}
\alias{run_primersearch}
\title{Execute EMBOSS Primerseach}
\usage{
run_primersearch(seq_path, primer_path, mismatch = 5,
  output_path = tempfile(), program_path = "primersearch",
  dont_run = FALSE, ...)
}
\arguments{
\item{seq_path}{A character vector of length 1. The path to the fasta file containing reference
sequences to search for primer matches in.}

\item{primer_path}{A character vector of length 1. The path to the file containing primer pairs
to match. The file should be whitespace-delimited with 3 columns: primer name, first primer
sequence, and second primer sequence.}

\item{mismatch}{An integer vector of length 1. The percentage of mismatches allowed.}

\item{output_path}{A character vector of length 1. Where the output of primersearch is saved.}

\item{program_path}{A character vector of length 1. The location of the primersearch binary.
Ideally, it should be in your system's search path.}

\item{dont_run}{If TRUE, the command is generated, but not executed. This could be useful if you
want to execute the command yourself.}

\item{...}{Additional arguments are passed to \code{primersearch}.}
}
\value{
The command generated as a character vector of length 1.
}
\description{
Execute EMBOSS Primerseach
}
\seealso{
\code{\link{parse_primersearch}}
}
\keyword{internal}
