% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_permute.R
\name{permuteFE}
\alias{permuteFE}
\title{A function returns the Q-between from the tree with given size}
\usage{
permuteFE(
  mf,
  Call,
  nsplit,
  P = 100,
  sss,
  lookahead,
  minbucket = 3,
  minsplit = 6,
  cp = 1e-04,
  maxdepth = 10,
  alpha.endcut = 0.02,
  a = 50,
  multi.start = T,
  n.starts = 3,
  ...
)
}
\arguments{
\item{mf}{data transformed to fit the tree.}

\item{Call}{The matched call.}

\item{nsplit}{the required number of splits.}

\item{P}{the number of permuted data sets.}

\item{sss}{boolean indicating whether the SSS strategy is used or not.}

\item{lookahead}{a boolean argument indicating whether to apply the "look-ahead" strategy when fitting the tree}

\item{minbucket}{the minimum number of observations in any terminal <leaf> node.}

\item{minsplit}{the minimum number of observations that must exist in a node in order for a split to be attempted.}

\item{cp}{complexity parameter as in rpart.}

\item{maxdepth}{set the maximum depth of any node of the final tree, with the root node counted as depth 0.}

\item{alpha.endcut}{parameter used in the splitting algorithm to avoid the endcut preference problem.}

\item{a}{parameter used in the sss to determine the slope of the logistic function that replaces the indicator function.}

\item{multi.start}{boolean indicating whether multiple starts must be used}

\item{n.starts}{number of multiple starts}

\item{...}{Additional arguments passed to prune.rpart().}
}
\value{
The pruned tree
}
\description{
A function returns the Q-between from the tree with given size
}
\keyword{internal}
