% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaSDTreg.r
\name{starting.vals.PPO}
\alias{starting.vals.PPO}
\title{Starting values from PPO}
\usage{
starting.vals.PPO(formula0, data0, control0, L0, K0, n.covar0)
}
\arguments{
\item{formula0}{See \code{\link{metaSDTreg}}.}

\item{data0}{Data frame.}

\item{control0}{See \code{\link{metaSDTcontrol}}.}

\item{L0}{Number of levels in ordinal type 2 response.}

\item{K0}{Number of levels of ordinal response 'A'.}

\item{n.covar0}{Number of covariates aside from the 'signal' variable.}
}
\value{
A named vector of starting values.
}
\description{
Used by \command{metaSDTreg} to calculate starting values using the partial proportional odds model as implemented in \pkg{ordinal}. Internal function.
}
\details{
The function calls the \code{\link[ordinal]{clm}} function using \code{all.vars(update(formula0, . ~ . - signal))} as the formula argument and using \code{~ signal} as the nominal argument (also see \code{\link{metaSDTreg}} for the meaning of the signal variable).
The coefficients of the signal variable are weighted together within the noise- and signal-specific type 2 responses using their inverse standard errors as weights.
}
\keyword{internal}
