% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ETASQ.R
\name{es_from_etasq_adj}
\alias{es_from_etasq_adj}
\title{Convert an adjusted eta-squared value (i.e., from an ANCOVA) to various effect size measures}
\usage{
es_from_etasq_adj(
  etasq_adj,
  n_exp,
  n_nexp,
  n_cov_ancova,
  cov_outcome_r,
  smd_to_cor = "viechtbauer",
  reverse_etasq
)
}
\arguments{
\item{etasq_adj}{an adjusted eta-squared value (i.e., obtained from an ANCOVA model)}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{n_cov_ancova}{number of covariates in the ANCOVA model.}

\item{cov_outcome_r}{correlation between the outcome and covariate (multiple correlation when multiple covariates are included in the ANCOVA model).}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_etasq}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 18. Adjusted: ANCOVA statistics, eta-squared'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert an adjusted eta-squared value (i.e., from an ANCOVA) to various effect size measures
}
\details{
This function first computes an adjusted Cohen's d (D) and Hedges' g (G)
from the adjusted eta squared of a binary predictor (ANCOVA model).
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{To estimate a Cohen's d} the following formula is used (Cohen, 1988):
\deqn{d\_adj = 2 * \sqrt{\frac{etasq\_adj}{1 - etasq\_adj}}}

\strong{To estimate other effect size measures},
calculations of the \code{\link{es_from_cohen_d_adj}()} are applied.
}
\examples{
es_from_etasq_adj(etasq = 0.28, n_cov_ancova = 3, cov_outcome_r = 0.2, n_exp = 20, n_nexp = 22)
}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences. Routledge.
}
