% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_stand_OR.R
\name{es_from_or_pval}
\alias{es_from_or_pval}
\title{Convert an odds ratio value and its standard error to several effect size measures}
\usage{
es_from_or_pval(
  or,
  logor,
  or_pval,
  baseline_risk,
  small_margin_prop,
  n_exp,
  n_nexp,
  n_cases,
  n_controls,
  n_sample,
  or_to_rr = "metaumbrella_cases",
  or_to_cor = "bonett",
  reverse_or_pval
)
}
\arguments{
\item{or}{odds ratio value}

\item{logor}{log odds ratio value}

\item{or_pval}{p-value of the (log) odds ratio}

\item{baseline_risk}{proportion of cases in the non-exposed group (only required for the \code{or_to_rr = "grant"} argument).}

\item{small_margin_prop}{smallest margin proportion of the underlying 2x2 table}

\item{n_exp}{number of participants in the exposed group (only required for the \code{or_to_rr = "grant"}, and \code{or_to_rr = "metaumbrella_exp"} arguments)}

\item{n_nexp}{number of participants in the non-exposed group (only required for the \code{or_to_rr = "grant"}, and \code{or_to_rr = "metaumbrella_exp"} arguments)}

\item{n_cases}{number of cases/events}

\item{n_controls}{number of controls/no-event}

\item{n_sample}{total number of participants in the sample}

\item{or_to_rr}{formula used to convert the \code{or} value into a risk ratio (see details).}

\item{or_to_cor}{formula used to convert the \code{or} value into a correlation coefficient (see details).}

\item{reverse_or_pval}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab OR\cr
\tab \cr
\code{converted effect size measure} \tab RR + NNT\cr
\code{} \tab D + G + R + Z\cr
\tab \cr
\code{required input data} \tab See 'Section 2. Odds Ratio'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert an odds ratio value and its standard error to several effect size measures
}
\details{
This function computes the standard error of the (log) odds ratio into
from a p-value (Section 6.3.2 in the Cochrane Handbook).
\deqn{logor\_z = qnorm(or_pval/2, lower.tail=FALSE)}
\deqn{logor\_se = |\frac{\log(or)}{logor\_z}|}

Then, calculations of \code{\link{es_from_or_se}()} are applied.
}
\examples{
es_or <- es_from_or_pval(
  or = 3.51, or_pval = 0.001,
  n_cases = 12, n_controls = 68
)
}
\references{
Higgins, J. P., Thomas, J., Chandler, J., Cumpston, M., Li, T., Page, M. J., & Welch, V. A. (Eds.). (2019). Cochrane handbook for systematic reviews of interventions. John Wiley & Sons.
}
