% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_REGRESSION.R
\name{es_from_beta_std}
\alias{es_from_beta_std}
\title{Convert a standardized regression coefficient and the standard deviation of the dependent variable
into several effect size measures}
\usage{
es_from_beta_std(
  beta_std,
  sd_dv,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_beta_std
)
}
\arguments{
\item{beta_std}{a standardized regression coefficient value (binary predictor, no other covariables in the model)}

\item{sd_dv}{standard deviation of the dependent variable}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_beta_std}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 13. (Un-)Standardized regression coefficient'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert a standardized regression coefficient and the standard deviation of the dependent variable
into several effect size measures
}
\details{
This function converts a standardized linear regression coefficient
(coming from a model with only one binary predictor), into an
unstandardized linear regression coefficient.

\deqn{sd\_dummy = \sqrt{\frac{n_exp - (n_exp^2 / (n_exp + n_nexp))}{(n_exp + n_nexp - 1)}}}
\deqn{unstd\_beta = beta\_std * \frac{sd\_dv}{sd\_dummy}}

Calculations of the \code{\link{es_from_beta_unstd}} functions are then used.
}
\examples{
es_from_beta_std(beta_std = 2.1, sd_dv = 0.98, n_exp = 20, n_nexp = 22)
}
\references{
Lipsey, M. W., & Wilson, D. B. (2001). Practical meta-analysis. Sage Publications, Inc.
}
