% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_forest.R
\name{plot_forest}
\alias{plot_forest}
\title{Forest Plot for Meta-Analysis}
\usage{
plot_forest(
  meta,
  from,
  to,
  shrinked = "random",
  summary = c("mean", "hpd"),
  mar = c(4.5, 12, 4, 0.3),
  cex.axis = 1,
  ...
)
}
\arguments{
\item{meta}{fitted meta-analysis model}

\item{from}{lower limit of the x-axis}

\item{to}{upper limit of the x-axis}

\item{shrinked}{which meta-analysis model should be used to show (shrinked)
estimates of the study effect sizes. The name must match the corresponding
name in the list \code{meta}. Can be suppressed by \code{shrinked = ""}}

\item{summary}{character vector with two values: first, either \code{"mean"}
or \code{"50\%"}; and second, either highest-probability-density interval \code{"hpd"}
or the Bayesian credibility interval \code{"bci"}.}

\item{mar}{margin of the plot in the order \code{c(bottom, left, top, right)}
(see \code{\link[graphics]{par}})}

\item{cex.axis}{size of the y-axis annotation for the labels of studies.}

\item{...}{arguments passed to \code{\link[graphics]{plot}} (e.g., \code{from}, \code{to})}
}
\description{
Plots estimated effect sizes for all studies.
}
\examples{
data(towels)
mf <- meta_fixed(logOR, SE, study, towels)
plot_forest(mf, mar = c(4.5, 20, 4, .2), xlab = "Log Odds Ratio")
}
\seealso{
\link{meta_bma}, \link{meta_fixed}, \link{meta_random}
}
