% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabind.R
\name{metabind}
\alias{metabind}
\title{Combine and summarize meta-analysis objects}
\usage{
metabind(..., name, pooled, backtransf, outclab)
}
\arguments{
\item{...}{Any number of meta-analysis objects or a single list
with meta-analyses.}

\item{name}{An optional character vector providing descriptive
names for the meta-analysis objects.}

\item{pooled}{A character string indicating whether results of a
fixed effect or random effects model should be considered. Either
\code{"fixed"} or \code{"random"}, can be abbreviated.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If
\code{backtransf=TRUE} (default), results for \code{sm="OR"} are
printed as odds ratios rather than log odds ratios, for example.}

\item{outclab}{Outcome label for all meta-analyis objects.}
}
\value{
An object of class \code{c("metabind", "meta")} with corresponding
\code{print}, \code{summary}, and \code{forest} functions. See
\code{\link{metagen}} for more information on list elements.
}
\description{
This function can be used to combine meta-analysis objects and is,
for example, useful to summarize results of various meta-analysis
methods or to generate a forest plot with results of several
subgroup analyses.
}
\details{
This function can be used to combine any number of meta-analysis
objects which is useful, for example, to summarize results of
various meta-analysis methods or to generate a forest plot with
results of several subgroup analyses (see Examples).

Individual study results are not retained with
\code{metabind}. This is possible using R function
\code{\link{metamerge}} which, however, can only be used to combine
results of two meta-analyses.
}
\examples{
data(Fleiss1993cont)

# Add some (fictitious) grouping variables:
#
Fleiss1993cont$age <- c(55, 65, 55, 65, 55)
Fleiss1993cont$region <- c("Europe", "Europe", "Asia", "Asia", "Europe")

m1 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
               data = Fleiss1993cont, sm = "MD")

# Conduct two subgroup analyses
#
mu1 <- update(m1, subgroup = age, subgroup.name = "Age group")
mu2 <- update(m1, subgroup = region, subgroup.name = "Region")

# Combine subgroup meta-analyses and show forest plot with subgroup
# results
#
mb1 <- metabind(mu1, mu2)
mb1
forest(mb1)

# Use various estimation methods for between-study heterogeneity
# variance
#
m1.pm <- update(m1, method.tau = "PM")
m1.reml <- update(m1, method.tau = "REML")
m1.ml <- update(m1, method.tau = "ML")
m1.hs <- update(m1, method.tau = "HS")
m1.sj <- update(m1, method.tau = "SJ")
m1.he <- update(m1, method.tau = "HE")
m1.eb <- update(m1, method.tau = "EB")

# Combine meta-analyses and show results
#
taus <- c("DerSimonian-Laird estimator",
          "Paule-Mandel estimator",
          "Restricted maximum-likelihood estimator",
          "Maximum-likelihood estimator",
          "Hunter-Schmidt estimator",
          "Sidik-Jonkman estimator",
          "Hedges estimator",
          "Empirical Bayes estimator")
#
m1.taus <- metabind(m1, m1.pm, m1.reml, m1.ml, m1.hs, m1.sj, m1.he, m1.eb,
                    name = taus, pooled = "random")
m1.taus
forest(m1.taus, print.I2 = FALSE, print.pval.Q = FALSE)

}
\seealso{
\code{\link{metagen}}, \code{\link{forest.metabind}},
  \code{\link{metamerge}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
