% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metagen.R
\name{metagen}
\alias{metagen}
\title{Generic inverse variance meta-analysis}
\usage{
metagen(
  TE,
  seTE,
  studlab,
  data = NULL,
  subset = NULL,
  exclude = NULL,
  sm = "",
  method.ci = if (missing(df)) "z" else "t",
  level = gs("level"),
  level.comb = gs("level.comb"),
  comb.fixed = gs("comb.fixed"),
  comb.random = gs("comb.random"),
  overall = comb.fixed | comb.random,
  overall.hetstat = comb.fixed | comb.random,
  hakn = gs("hakn"),
  adhoc.hakn = gs("adhoc.hakn"),
  method.tau = gs("method.tau"),
  method.tau.ci = if (method.tau == "DL") "J" else "QP",
  tau.preset = NULL,
  TE.tau = NULL,
  tau.common = gs("tau.common"),
  prediction = gs("prediction"),
  level.predict = gs("level.predict"),
  null.effect = 0,
  method.bias = gs("method.bias"),
  n.e = NULL,
  n.c = NULL,
  pval,
  df,
  lower,
  upper,
  level.ci = 0.95,
  median,
  q1,
  q3,
  min,
  max,
  method.mean = "Luo",
  method.sd = "Shi",
  approx.TE,
  approx.seTE,
  backtransf = gs("backtransf"),
  pscale = 1,
  irscale = 1,
  irunit = "person-years",
  title = gs("title"),
  complab = gs("complab"),
  outclab = "",
  label.e = gs("label.e"),
  label.c = gs("label.c"),
  label.left = gs("label.left"),
  label.right = gs("label.right"),
  byvar,
  bylab,
  print.byvar = gs("print.byvar"),
  byseparator = gs("byseparator"),
  keepdata = gs("keepdata"),
  warn = gs("warn"),
  control = NULL
)
}
\arguments{
\item{TE}{Estimate of treatment effect, e.g., log hazard ratio or
risk difference.}

\item{seTE}{Standard error of treatment estimate.}

\item{studlab}{An optional vector with study labels.}

\item{data}{An optional data frame containing the study
information.}

\item{subset}{An optional vector specifying a subset of studies to
be used (see Details).}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots (see Details).}

\item{sm}{A character string indicating underlying summary measure,
e.g., \code{"RD"}, \code{"RR"}, \code{"OR"}, \code{"ASD"},
\code{"HR"}, \code{"MD"}, \code{"SMD"}, or \code{"ROM"}.}

\item{method.ci}{A character string indicating which method is used
to calculate confidence intervals for individual studies, see
Details.}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{level.comb}{The level used to calculate confidence intervals
for pooled estimates.}

\item{comb.fixed}{A logical indicating whether a fixed effect
meta-analysis should be conducted.}

\item{comb.random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{hakn}{A logical indicating whether method by Hartung and
Knapp should be used to adjust test statistics and confidence
intervals.}

\item{adhoc.hakn}{A character string indicating whether an \emph{ad
hoc} variance correction should be applied in the case of an
arbitrarily small Hartung-Knapp variance estimate. Either
\code{""}, \code{"se"}, or \code{"ci"} (see Details), can be
abbreviated.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau}. Either \code{"DL"}, \code{"PM"},
\code{"REML"}, \code{"ML"}, \code{"HS"}, \code{"SJ"},
\code{"HE"}, or \code{"EB"}, can be abbreviated.}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau}. Either \code{"QP"}, \code{"BJ"}, or \code{"J"}, or
\code{""}, can be abbreviated.}

\item{tau.preset}{Prespecified value for the square root of the
between-study variance \eqn{\tau^2}.}

\item{TE.tau}{Overall treatment effect used to estimate the
between-study variance tau-squared.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{null.effect}{A numeric value specifying the effect under the
null hypothesis.}

\item{method.bias}{A character string indicating which test is to
be used.  Either \code{"rank"}, \code{"linreg"}, or \code{"mm"},
can be abbreviated.  See function \code{\link{metabias}}.}

\item{n.e}{Number of observations in experimental group (or total
sample size in study).}

\item{n.c}{Number of observations in control group.}

\item{pval}{P-value (used to estimate the standard error).}

\item{df}{Degrees of freedom (used in test or to construct
confidence interval).}

\item{lower}{Lower limit of confidence interval (used to estimate
the standard error).}

\item{upper}{Upper limit of confidence interval (used to estimate
the standard error).}

\item{level.ci}{Level of confidence interval.}

\item{median}{Median (used to estimate the treatment effect and
standard error).}

\item{q1}{First quartile (used to estimate the treatment effect and
standard error).}

\item{q3}{Third quartile (used to estimate the treatment effect and
standard error).}

\item{min}{Minimum (used to estimate the treatment effect and
standard error).}

\item{max}{Maximum (used to estimate the treatment effect and
standard error).}

\item{method.mean}{A character string indicating which method to
use to approximate the mean from the median and other statistics
(see Details).}

\item{method.sd}{A character string indicating which method to use
to approximate the standard deviation from sample size, median,
interquartile range and range (see Details).}

\item{approx.TE}{Approximation method to estimate treatment
estimate (see Details).}

\item{approx.seTE}{Approximation method to estimate standard error
(see Details).}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If \code{backtransf =
TRUE} (default), results for \code{sm = "OR"} are printed as odds
ratios rather than log odds ratios and results for \code{sm =
"ZCOR"} are printed as correlations rather than Fisher's z
transformed correlations, for example.}

\item{pscale}{A numeric giving scaling factor for printing of
single event probabilities or risk differences, i.e. if argument
\code{sm} is equal to \code{"PLOGIT"}, \code{"PLN"},
\code{"PRAW"}, \code{"PAS"}, \code{"PFT"}, or \code{"RD"}.}

\item{irscale}{A numeric defining a scaling factor for printing of
single incidence rates or incidence rate differences, i.e. if
argument \code{sm} is equal to \code{"IR"}, \code{"IRLN"},
\code{"IRS"}, \code{"IRFT"}, or \code{"IRD"}.}

\item{irunit}{A character specifying the time unit used to
calculate rates, e.g. person-years.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{label.e}{Label for experimental group.}

\item{label.c}{Label for control group.}

\item{label.left}{Graph label on left side of forest plot.}

\item{label.right}{Graph label on right side of forest plot.}

\item{byvar}{An optional vector containing grouping information
(must be of same length as \code{TE}).}

\item{bylab}{A character string with a label for the grouping
variable.}

\item{print.byvar}{A logical indicating whether the name of the
grouping variable should be printed in front of the group labels.}

\item{byseparator}{A character string defining the separator
between label and levels of grouping variable.}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{warn}{A logical indicating whether warnings should be printed
(e.g., if studies are excluded from meta-analysis due to zero
standard errors).}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance \eqn{\tau^2}. This argument
is passed on to \code{\link[metafor]{rma.uni}}.}
}
\value{
An object of class \code{c("metagen", "meta")} with corresponding
\code{print}, \code{summary}, and \code{forest} functions. The
object is a list containing the following components:
\item{TE, seTE, studlab, exclude, n.e, n.c}{As defined above.}
\item{sm, method.ci, level, level.comb,}{As defined above.}
\item{comb.fixed, comb.random,}{As defined above.}
\item{overall, overall.hetstat,}{As defined above.}
\item{hakn, adhoc.hakn, method.tau, method.tau.ci,}{As defined above.}
\item{tau.preset, TE.tau, method.bias,}{As defined above.}
\item{tau.common, title, complab, outclab,}{As defined above.}
\item{label.e, label.c, label.left, label.right,}{As defined
  above.}
\item{byvar, bylab, print.byvar, byseparator, warn}{As defined
  above.}
\item{lower, upper}{Lower and upper confidence interval limits for
  individual studies.}
\item{statistic, pval}{Statistic and p-value for test of treatment
  effect for individual studies.}
\item{w.fixed, w.random}{Weight of individual studies (in fixed and
  random effects model).}
\item{TE.fixed, seTE.fixed}{Estimated overall treatment effect and
  standard error (fixed effect model).}
\item{lower.fixed, upper.fixed}{Lower and upper confidence interval
  limits (fixed effect model).}
\item{statistic.fixed, pval.fixed}{Statistic and p-value for test of
  overall treatment effect (fixed effect model).}
\item{TE.random, seTE.random}{Estimated overall treatment effect
  and standard error (random effects model).}
\item{lower.random, upper.random}{Lower and upper confidence
  interval limits (random effects model).}
\item{statistic.random, pval.random}{Statistic and p-value for test
  of overall treatment effect (random effects model).}
\item{prediction, level.predict}{As defined above.}
\item{seTE.predict}{Standard error utilised for prediction
  interval.}
\item{lower.predict, upper.predict}{Lower and upper limits of
  prediction interval.}
\item{null.effect}{As defined above.}
\item{k}{Number of studies combined in meta-analysis.}
\item{Q}{Heterogeneity statistic.}
\item{df.Q}{Degrees of freedom for heterogeneity statistic.}
\item{pval.Q}{P-value of heterogeneity test.}
\item{tau2}{Between-study variance \eqn{\tau^2}.}
\item{se.tau2}{Standard error of \eqn{\tau^2}.}
\item{lower.tau2, upper.tau2}{Lower and upper limit of confidence
  interval for \eqn{\tau^2}.}
\item{tau}{Square-root of between-study variance \eqn{\tau}.}
\item{lower.tau, upper.tau}{Lower and upper limit of confidence
  interval for \eqn{\tau}.}
\item{H}{Heterogeneity statistic H.}
\item{lower.H, upper.H}{Lower and upper confidence limit for
 heterogeneity statistic H.}
\item{I2}{Heterogeneity statistic I\eqn{^2}.}
\item{lower.I2, upper.I2}{Lower and upper confidence limit for
  heterogeneity statistic I\eqn{^2}.}
\item{Rb}{Heterogeneity statistic R\eqn{_b}.}
\item{lower.Rb, upper.Rb}{Lower and upper confidence limit for
  heterogeneity statistic R\eqn{_b}.}
\item{approx.TE, approx.seTE}{As defined above.}
\item{method}{Pooling method: \code{"Inverse"}.}
\item{df.hakn}{Degrees of freedom for test of treatment effect for
  Hartung-Knapp method (only if \code{hakn = TRUE}).}
\item{bylevs}{Levels of grouping variable - if \code{byvar} is not
  missing.}
\item{TE.fixed.w, seTE.fixed.w}{Estimated treatment effect and
  standard error in subgroups (fixed effect model) - if
  \code{byvar} is not missing.}
\item{lower.fixed.w, upper.fixed.w}{Lower and upper confidence
  interval limits in subgroups (fixed effect model) - if
  \code{byvar} is not missing.}
\item{statistic.fixed.w, pval.fixed.w}{Statistics and p-values for
  test of treatment effect in subgroups (fixed effect model) - if
  \code{byvar} is not missing.}
\item{TE.random.w, seTE.random.w}{Estimated treatment effect and
  standard error in subgroups (random effects model) - if
  \code{byvar} is not missing.}
\item{lower.random.w, upper.random.w}{Lower and upper confidence
  interval limits in subgroups (random effects model) - if
  \code{byvar} is not missing.}
\item{statistic.random.w, pval.random.w}{Statistics and p-values
  for test of treatment effect in subgroups (random effects model)
  - if \code{byvar} is not missing.}
\item{w.fixed.w, w.random.w}{Weight of subgroups (in fixed and
  random effects model) - if \code{byvar} is not missing.}
\item{df.hakn.w}{Degrees of freedom for test of treatment effect
  for Hartung-Knapp method in subgroups - if \code{byvar} is not
  missing and \code{hakn = TRUE}.}
\item{n.harmonic.mean.w}{Harmonic mean of number of observations in
  subgroups (for back transformation of Freeman-Tukey Double
  arcsine transformation) - if \code{byvar} is not missing.}
\item{n.e.w}{Number of observations in experimental group in
  subgroups - if \code{byvar} is not missing.}
\item{n.c.w}{Number of observations in control group in subgroups -
  if \code{byvar} is not missing.}
\item{k.w}{Number of studies combined within
  subgroups - if \code{byvar} is not missing.}
\item{k.all.w}{Number of all studies in subgroups - if \code{byvar}
  is not missing.}
\item{Q.w.fixed}{Overall within subgroups heterogeneity statistic Q
  (based on fixed effect model) - if \code{byvar} is not missing.}
\item{Q.w.random}{Overall within subgroups heterogeneity statistic
  Q (based on random effects model) - if \code{byvar} is not
  missing (only calculated if argument \code{tau.common} is TRUE).}
\item{df.Q.w}{Degrees of freedom for test of overall within
  subgroups heterogeneity - if \code{byvar} is not missing.}
\item{pval.Q.w.fixed}{P-value of within subgroups heterogeneity
  statistic Q (based on fixed effect model) - if \code{byvar} is
  not missing.}
\item{pval.Q.w.random}{P-value of within subgroups heterogeneity
  statistic Q (based on random effects model) - if \code{byvar} is
  not missing.}
\item{Q.b.fixed}{Overall between subgroups heterogeneity statistic
  Q (based on fixed effect model) - if \code{byvar} is not
  missing.}
\item{Q.b.random}{Overall between subgroups heterogeneity statistic
  Q (based on random effects model) - if \code{byvar} is not
  missing.}
\item{df.Q.b}{Degrees of freedom for test of overall between
  subgroups heterogeneity - if \code{byvar} is not missing.}
\item{pval.Q.b.fixed}{P-value of between subgroups heterogeneity
  statistic Q (based on fixed effect model) - if \code{byvar} is
  not missing.}  \item{pval.Q.b.random}{P-value of between
  subgroups heterogeneity statistic Q (based on random effects
  model) - if \code{byvar} is not missing.}
\item{tau.w}{Square-root of between-study variance within subgroups
  - if \code{byvar} is not missing.}
\item{H.w}{Heterogeneity statistic H within subgroups - if
  \code{byvar} is not missing.}
\item{lower.H.w, upper.H.w}{Lower and upper confidence limit for
  heterogeneity statistic H within subgroups - if \code{byvar} is
  not missing.}
\item{I2.w}{Heterogeneity statistic I\eqn{^2} within subgroups - if
  \code{byvar} is not missing.}
\item{lower.I2.w, upper.I2.w}{Lower and upper confidence limit for
  heterogeneity statistic I\eqn{^2} within subgroups - if \code{byvar} is
  not missing.}
\item{keepdata}{As defined above.}
\item{data}{Original data (set) used in function call (if
  \code{keepdata = TRUE}).}
\item{subset}{Information on subset of original data used in
  meta-analysis (if \code{keepdata = TRUE}).}
\item{call}{Function call.}
\item{version}{Version of R package \bold{meta} used to create
  object.}
}
\description{
Fixed effect and random effects meta-analysis based on estimates
(e.g. log hazard ratios) and their standard errors. The inverse
variance method is used for pooling.
}
\details{
This function provides the \emph{generic inverse variance method}
for meta-analysis which requires treatment estimates and their
standard errors (Borenstein et al., 2010). The method is useful,
e.g., for pooling of survival data (using log hazard ratio and
standard errors as input). Arguments \code{TE} and \code{seTE} can
be used to provide treatment estimates and standard errors
directly. However, it is possible to derive these quantities from
other information.

Default settings are utilised for several arguments (assignments
using \code{\link{gs}} function). These defaults can be changed for
the current R session using the \code{\link{settings.meta}}
function.

Furthermore, R function \code{\link{update.meta}} can be used to
rerun a meta-analysis with different settings.

\subsection{Approximate treatment estimates}{

Missing treatment estimates can be derived from
\enumerate{
\item confidence limits provided by arguments \code{lower} and
  \code{upper};
\item median, interquartile range and range (arguments
  \code{median}, \code{q1}, \code{q3}, \code{min}, and \code{max});
\item median and interquartile range (arguments \code{median},
  \code{q1} and \code{q3});
\item median and range (arguments \code{median}, \code{min} and
  \code{max}).
}
For confidence limits, the treatment estimate is defined as the
center of the confidence interval (on the log scale for relative
effect measures like the odds ratio or hazard ratio).

If the treatment effect is a mean it can be approximated from
sample size, median, interquartile range and range. By default,
methods described in Luo et al. (2018) are utilized (argument
\code{method.mean = "Luo"}):
\itemize{
\item equation (7) if sample size, median and range are available,
\item equation (11) if sample size, median and interquartile range
  are available,
\item equation (15) if sample size, median, range and interquartile
  range are available.
}

Instead the methods described in Wan et al. (2014) are used if
argument \code{method.mean = "Wan"}):
\itemize{
\item equation (2) if sample size, median and range are available,
\item equation (14) if sample size, median and interquartile range
  are available,
\item equation (10) if sample size, median, range and interquartile
  range are available.
}

By default, missing treatment estimates are replaced successively
using these method, i.e., confidence limits are utilised before
interquartile ranges. Argument \code{approx.TE} can be used to
overwrite this default for each individual study:
\itemize{
\item Use treatment estimate directly (entry \code{""} in argument
  \code{approx.TE});
\item confidence limits (\code{"ci"} in argument \code{approx.TE});
\item median, interquartile range and range (\code{"iqr.range"});
\item median and interquartile range (\code{"iqr"});
\item median and range (\code{"range"}).
}
}

\subsection{Approximate standard errors}{

Missing standard errors can be derived from
\enumerate{
\item p-value provided by arguments \code{pval} and (optional)
  \code{df};
\item confidence limits (arguments \code{lower}, \code{upper}, and
  (optional) \code{df});
\item sample size, median, interquartile range and range (arguments
  \code{n.e} and / or \code{n.c}, \code{median}, \code{q1},
  \code{q3}, \code{min}, and \code{max});
\item sample size, median and interquartile range (arguments
  \code{n.e} and / or \code{n.c}, \code{median}, \code{q1} and
  \code{q3});
\item sample size, median and range (arguments \code{n.e} and / or
  \code{n.c}, \code{median}, \code{min} and \code{max}).
}
For p-values and confidence limits, calculations are either based
on the standard normal or \emph{t} distribution if argument
\code{df} is provided. Furthermore, argument \code{level.ci} can be
used to provide the level of the confidence interval.

Wan et al. (2014) describe methods to estimate the standard
deviation (and thus the standard error by deviding the standard
deviation with the square root of the sample size) from the sample
size, median and additional statistics. Shi et al. (2020) provide
an improved estimate of the standard deviation if the interquartile
range and range are available in addition to the sample size and
median. Accordingly, equation (11) in Shi et al. (2020) is the
default (argument \code{method.sd = "Shi"}), if the median,
interquartile range and range are provided (arguments
\code{median}, \code{q1}, \code{q3}, \code{min} and
\code{max}). The method by Wan et al. (2014) is used if argument
\code{method.sd = "Wan"} and, depending on the sample size, either
equation (12) or (13) is used. If only the interquartile range or
range is available, equations (15) / (16) and (7) / (9) in Wan et
al. (2014) are used, respectively. The sample size of individual
studies must be provided with arguments \code{n.e} and / or
\code{n.c}. The total sample size is calculated as \code{n.e} +
\code{n.c} if both arguments are provided.

By default, missing standard errors are replaced successively using
these method, e.g., p-value before confidence limits before
interquartile range and range. Argument \code{approx.seTE} can be
used to overwrite this default for each individual study:

\itemize{
\item Use standard error directly (entry \code{""} in argument
  \code{approx.seTE});
\item p-value (\code{"pval"} in argument \code{approx.seTE});
\item confidence limits (\code{"ci"});
\item median, interquartile range and range (\code{"iqr.range"});
\item median and interquartile range (\code{"iqr"});
\item median and range (\code{"range"}).
}
}

\subsection{Confidence intervals for individual studies}{

For the mean difference (argument \code{sm = "MD"}), the confidence
interval for individual studies can be based on the
\itemize{
\item standard normal distribution (\code{method.ci = "z"}), or
\item t-distribution (\code{method.ci = "t"}).
}

By default, the first method is used if argument \code{df} is
missing and the second method otherwise.

Note, this choice does not affect the results of the fixed effect
and random effects meta-analysis.
}

\subsection{Estimation of between-study variance}{

The following methods are available to estimate the between-study
variance \eqn{\tau^2}.
\tabular{ll}{
\bold{Argument}\tab \bold{Method} \cr 
\code{method.tau = "DL"}\tab DerSimonian-Laird estimator (DerSimonian and Laird, 1986) \cr
\code{method.tau = "PM"}\tab Paule-Mandel estimator (Paule and Mandel, 1982) \cr
\code{method.tau = "REML"}\tab Restricted maximum-likelihood estimator (Viechtbauer, 2005) \cr
\code{method.tau = "ML"}\tab Maximum-likelihood estimator (Viechtbauer, 2005) \cr
\code{method.tau = "HS"}\tab Hunter-Schmidt estimator (Hunter and Schmidt, 2015) \cr
\code{method.tau = "SJ"}\tab Sidik-Jonkman estimator (Sidik and Jonkman, 2005) \cr
\code{method.tau = "HE"}\tab Hedges estimator (Hedges and Olkin, 1985) \cr
\code{method.tau = "EB"}\tab Empirical Bayes estimator (Morris, 1983)
}

Historically, the DerSimonian-Laird method was the de facto
standard to estimate the between-study variance \eqn{\tau^2} and is
still the default in many software packages including Review
Manager 5 (RevMan 5) and R package \pkg{meta}. However, its role
has been challenged and especially the Paule-Mandel and REML
estimators have been recommended (Veroniki et al.,
2016). Accordingly, the following R command can be used to use the
Paule-Mandel estimator in all meta-analyses of the R session:
\code{settings.meta(method.tau = "PM")}
}

\subsection{Confidence interval for the between-study variance}{

The following methods to calculate a confidence interval for
\eqn{\tau^2} and \eqn{\tau} are available.
\tabular{ll}{
\bold{Argument}\tab \bold{Method} \cr 
\code{method.tau.ci = "J"}\tab Method by Jackson (2013) \cr
\code{method.tau.ci = "BJ"}\tab Method by Biggerstaff and Jackson (2008) \cr
\code{method.tau.ci = "QP"}\tab Q-Profile method (Viechtbauer, 2007)
}
These methods have been recommended by Veroniki et al. (2016). By
default, the Jackson method is used for the DerSimonian-Laird
estimator of \eqn{\tau^2} and the Q-profile method for all other
estimators of \eqn{\tau^2}. No confidence intervals for
\eqn{\tau^2} and \eqn{\tau} are calculated if \code{method.tau.ci =
""}.
}

\subsection{Hartung-Knapp method}{

Hartung and Knapp (2001a,b) proposed an alternative method for
random effects meta-analysis based on a refined variance estimator
for the treatment estimate. Simulation studies (Hartung and Knapp,
2001a,b; IntHout et al., 2014; Langan et al., 2019) show improved
coverage probabilities compared to the classic random effects
method. However, in rare settings with very homogeneous treatment
estimates, the Hartung-Knapp (HK) variance estimate can be
arbitrarily small resulting in a very narrow confidence interval
(Knapp and Hartung, 2003; Wiksten et al., 2016). In such cases, an
\emph{ad hoc} variance correction has been proposed by utilising
the variance estimate from the classic random effects model (Knapp
and Hartung, 2003). Argument \code{adhoc.hakn} can be used to
choose the \emph{ad hoc} method:
\tabular{ll}{
\bold{Argument}\tab \bold{\emph{Ad hoc} method} \cr 
\code{adhoc.hakn = ""}\tab not used \cr
\code{adhoc.hakn = "se"}\tab used if HK standard error is smaller than
 standard error \cr
 \tab from classic random effects model (Knapp and Hartung, 2003) \cr
\code{adhoc.hakn = "ci"}\tab used if HK confidence interval is
 narrower than CI from \cr
 \tab classic random effects model with DL estimator (IQWiG, 2020)
}
}

\subsection{Prediction interval}{

A prediction interval for the treatment effect of a new study
(Higgins et al., 2009) is calculated if arguments \code{prediction}
and \code{comb.random} are \code{TRUE}. Note, the definition of
prediction intervals varies in the literature. This function
implements equation (12) of Higgins et al., (2009) which proposed a
\emph{t} distribution with \emph{K-2} degrees of freedom where
\emph{K} corresponds to the number of studies in the meta-analysis.
}

\subsection{Subgroup analysis}{

Argument \code{byvar} can be used to conduct subgroup analysis for
a categorical covariate. The \code{\link{metareg}} function can be
used instead for more than one categorical covariate or continuous
covariates.
}

\subsection{Specify the null hypothesis of test for an overall effect}{

Argument \code{null.effect} can be used to specify the (treatment)
effect under the null hypothesis in a test for an overall
effect.

By default (\code{null.effect = 0}), the null hypothesis
corresponds to "no difference" (which is obvious for absolute
effect measures like the mean difference (\code{sm = "MD"}) or
standardised mean difference (\code{sm = "SMD"})). For relative
effect measures, e.g., risk ratio (\code{sm = "RR"}) or odds ratio
(\code{sm = "OR"}), the null effect is defined on the log scale,
i.e., \emph{ln}(RR) = 0 or \emph{ln}(OR) = 0 which is equivalent to
testing RR = 1 or OR = 1.

Use of argument \code{null.effect} is especially useful for summary
measures without a "natural" null effect, i.e., in situations
without a second (treatment) group. For example, an overall
proportion of 50\% could be tested in the meta-analysis of single
proportions with argument \code{null.effect = 0.5}.

Note, all tests for an overall effect are two-sided with the
alternative hypothesis that the effect is unequal to
\code{null.effect}.
}

\subsection{Exclusion of studies from meta-analysis}{

Arguments \code{subset} and \code{exclude} can be used to exclude
studies from the meta-analysis. Studies are removed completely from
the meta-analysis using argument \code{subset}, while excluded
studies are shown in printouts and forest plots using argument
\code{exclude} (see Examples).
Meta-analysis results are the same for both arguments.
}

\subsection{Presentation of meta-analysis results}{

Internally, both fixed effect and random effects models are
calculated regardless of values choosen for arguments
\code{comb.fixed} and \code{comb.random}. Accordingly, the estimate
for the random effects model can be extracted from component
\code{TE.random} of an object of class \code{"meta"} even if
argument \code{comb.random = FALSE}. However, all functions in R
package \bold{meta} will adequately consider the values for
\code{comb.fixed} and \code{comb.random}. For example, functions
\code{\link{print.meta}} and \code{\link{forest.meta}} will not
show results for the random effects model if \code{comb.random =
FALSE}.

Argument \code{pscale} can be used to rescale single proportions or
risk differences, e.g. \code{pscale = 1000} means that proportions
are expressed as events per 1000 observations. This is useful in
situations with (very) low event probabilities.

Argument \code{irscale} can be used to rescale single rates or rate
differences, e.g. \code{irscale = 1000} means that rates are
expressed as events per 1000 time units, e.g. person-years. This is
useful in situations with (very) low rates. Argument \code{irunit}
can be used to specify the time unit used in individual studies
(default: "person-years"). This information is printed in summaries
and forest plots if argument \code{irscale} is not equal to 1.

Default settings for \code{comb.fixed}, \code{comb.random},
\code{pscale}, \code{irscale}, \code{irunit} and several other
arguments can be set for the whole R session using
\code{\link{settings.meta}}.
}
}
\note{
R function \code{\link[metafor]{rma.uni}} from R package
\pkg{metafor} (Viechtbauer 2010) is called internally to estimate
the between-study variance \eqn{\tau^2}.
}
\examples{
data(Fleiss1993bin)
m1 <- metabin(d.asp, n.asp, d.plac, n.plac, study,
              data = Fleiss1993bin, sm = "RR", method = "I")
m1

# Identical results using the generic inverse variance method with
# log risk ratio and its standard error:
# Note, argument 'n.e' in metagen() is used to provide the total
# sample size which is calculated from the group sample sizes n.e
# and n.c in meta-analysis m1.
m1.gen <- metagen(TE, seTE, studlab, n.e = n.e + n.c, data = m1, sm = "RR")
m1.gen
forest(m1.gen, leftcols = c("studlab", "n.e", "TE", "seTE"))


# Meta-analysis with prespecified between-study variance
#
summary(metagen(m1$TE, m1$seTE, sm = "RR", tau.preset = sqrt(0.1)))


# Meta-analysis of survival data:
#
logHR <- log(c(0.95, 1.5))
selogHR <- c(0.25, 0.35)
metagen(logHR, selogHR, sm = "HR")


# Paule-Mandel method to estimate between-study variance for data
# from Paule & Mandel (1982)
#
average <- c(27.044, 26.022, 26.340, 26.787, 26.796)
variance <- c(0.003, 0.076, 0.464, 0.003, 0.014)
#
summary(metagen(average, sqrt(variance), sm = "MD", method.tau = "PM"))


# Conduct meta-analysis using hazard ratios and 95\% confidence intervals
#
# Data from Steurer et al. (2006), Analysis 1.1 Overall survival
# https://www.cochranelibrary.com/cdsr/doi/10.1002/14651858.CD004270.pub2/abstract
#
study <- c("FCG on CLL 1996", "Leporrier 2001", "Rai 2000", "Robak 2000")
HR <- c(0.55, 0.92, 0.79, 1.18)
lower.HR <- c(0.28, 0.79, 0.59, 0.64)
upper.HR <- c(1.09, 1.08, 1.05, 2.17)
#
# Input must be log hazard ratios, not hazard ratios
#
metagen(log(HR), lower = log(lower.HR), upper = log(upper.HR),
        studlab = study, sm = "HR")


# Exclude MRC-1 and MRC-2 studies from meta-analysis, however,
# show them in printouts and forest plots
#
metabin(d.asp, n.asp, d.plac, n.plac, study,
        data = Fleiss1993bin, sm = "RR", method = "I",
        exclude = study \%in\% c("MRC-1", "MRC-2"))
#
# Exclude MRC-1 and MRC-2 studies completely from meta-analysis
#
metabin(d.asp, n.asp, d.plac, n.plac, study,
        data = Fleiss1993bin, sm = "RR", method = "I",
        subset = !(study \%in\% c("MRC-1", "MRC-2")))


# Exclude studies with total sample size above 1500
#
metabin(d.asp, n.asp, d.plac, n.plac, study,
        data = Fleiss1993bin, sm = "RR", method = "I",
        exclude = (n.asp + n.plac) > 1500)

# Exclude studies containing "MRC" in study name
#
metabin(d.asp, n.asp, d.plac, n.plac, study,
        data = Fleiss1993bin, sm = "RR", method = "I",
        exclude = grep("MRC", study))

# Use both arguments 'subset' and 'exclude'
#
metabin(d.asp, n.asp, d.plac, n.plac, study,
        data = Fleiss1993bin, sm = "RR", method = "I",
        subset = (n.asp + n.plac) > 1500,
        exclude = grep("MRC", study))

}
\references{
Biggerstaff BJ, Jackson D (2008):
The exact distribution of Cochran’s heterogeneity statistic in
one-way random effects meta-analysis.
\emph{Statistics in Medicine},
\bold{27}, 6093--110

Borenstein M, Hedges LV, Higgins JP, Rothstein HR (2010):
A basic introduction to fixed-effect and random-effects models for
meta-analysis.
\emph{Research Synthesis Methods},
\bold{1}, 97--111

Cooper H & Hedges LV (1994):
\emph{The Handbook of Research Synthesis}.
Newbury Park, CA: Russell Sage Foundation

DerSimonian R & Laird N (1986):
Meta-analysis in clinical trials.
\emph{Controlled Clinical Trials},
\bold{7}, 177--88

Hedges LV & Olkin I (1985):
\emph{Statistical methods for meta-analysis}.
San Diego, CA: Academic Press

Higgins JPT, Thompson SG, Spiegelhalter DJ (2009):
A re-evaluation of random-effects meta-analysis.
\emph{Journal of the Royal Statistical Society: Series A},
\bold{172}, 137--59

Hunter JE & Schmidt FL (2015):
\emph{Methods of Meta-Analysis: Correcting Error and Bias in
Research Findings} (Third edition).
Thousand Oaks, CA: Sage

Hartung J, Knapp G (2001a):
On tests of the overall treatment effect in meta-analysis with
normally distributed responses.
\emph{Statistics in Medicine},
\bold{20}, 1771--82

Hartung J, Knapp G (2001b):
A refined method for the meta-analysis of controlled clinical
trials with binary outcome.
\emph{Statistics in Medicine},
\bold{20}, 3875--89

IntHout J, Ioannidis JPA, Borm GF (2014):
The Hartung-Knapp-Sidik-Jonkman method for random effects
meta-analysis is straightforward and considerably outperforms the
standard DerSimonian-Laird method.
\emph{BMC Medical Research Methodology},
\bold{14}, 25

IQWiG (2020):
General Methods: Draft of Version 6.0.
\url{https://www.iqwig.de/en/methods/methods-paper.3020.html}

Jackson D (2013):
Confidence intervals for the between-study variance in random
effects meta-analysis using generalised Cochran heterogeneity
statistics.
\emph{Research Synthesis Methods},
\bold{4}, 220--229

Knapp G & Hartung J (2003):
Improved tests for a random effects meta-regression with a single
covariate.
\emph{Statistics in Medicine},
\bold{22}, 2693--710

Langan D, Higgins JPT, Jackson D, Bowden J, Veroniki AA,
Kontopantelis E, et al. (2019):
A comparison of heterogeneity variance estimators in simulated
random-effects meta-analyses.
\emph{Research Synthesis Methods},
\bold{10}, 83--98

Luo D, Wan X, Liu J, Tong T (2018):
Optimally estimating the sample mean from the sample size, median,
mid-range, and/or mid-quartile range.
\emph{Statistical Methods in Medical Research},
\bold{27}, 1785--805

Morris CN (1983):
Parametric empirical Bayes inference: Theory and applications (with
discussion).
\emph{Journal of the American Statistical Association}
\bold{78}, 47--65

Paule RC & Mandel J (1982):
Consensus values and weighting factors.
\emph{Journal of Research of the National Bureau of Standards},
\bold{87}, 377--85

\emph{Review Manager (RevMan)} [Computer program]. Version 5.3.
Copenhagen: The Nordic Cochrane Centre, The Cochrane Collaboration, 2014

Shi J, Luo D, Weng H, Zeng X-T, Lin L, Chu H, et al. (2020):
Optimally estimating the sample standard deviation from the
five-number summary.
\emph{Research Synthesis Methods}.

Sidik K & Jonkman JN (2005):
Simple heterogeneity variance estimation for meta-analysis.
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)},
\bold{54}, 367--84

Veroniki AA, Jackson D, Viechtbauer W, Bender R, Bowden J, Knapp G,
et al. (2016):
Methods to estimate the between-study variance and its uncertainty
in meta-analysis.
\emph{Research Synthesis Methods},
\bold{7}, 55--79 

Viechtbauer W (2005):
Bias and efficiency of meta-analytic variance estimators in the
random-effects model.
\emph{Journal of Educational and Behavioral Statistics},
\bold{30}, 261--93

Viechtbauer W (2007):
Confidence intervals for the amount of heterogeneity in
meta-analysis.
\emph{Statistics in Medicine},
\bold{26}, 37--52

Viechtbauer W (2010):
Conducting Meta-Analyses in R with the metafor Package.
\emph{Journal of Statistical Software},
\bold{36}, 1--48

Wan X, Wang W, Liu J, Tong T (2014):
Estimating the sample mean and standard deviation from the sample
size, median, range and/or interquartile range.
\emph{BMC Medical Research Methodology},
\bold{14}, 135

Wiksten A, Rücker G, Schwarzer G (2016):
Hartung-Knapp method is not always conservative compared with
fixed-effect meta-analysis.
\emph{Statistics in Medicine},
\bold{35}, 2503--15
}
\seealso{
\code{\link{update.meta}}, \code{\link{metabin}},
  \code{\link{metacont}}, \code{\link{print.meta}},
  \code{\link{settings.meta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
