% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_funs.R
\name{JumpBy}
\alias{JumpBy}
\title{Skip observations}
\usage{
JumpBy(x, by, start = 1, fill = NULL)
}
\arguments{
\item{x}{vector}

\item{by}{numeric interval between elements to keep}

\item{start}{index to start from}

\item{fill}{how observations are skipped}
}
\value{
A vector of the same class as x and, if \code{fill} is not \code{null},
the same length.
}
\description{
Skip observations
}
\details{
Mostly useful for labelling only every \code{by}th element.
}
\examples{
x <- 1:50
JumpBy(x, 2)   # only odd numbers
JumpBy(x, 2, start = 2)   # only even numbers
JumpBy(x, 2, fill = NA)   # even numbers replaced by NA
JumpBy(x, 2, fill = 6)   # even numbers replaced by 6

}
\seealso{
Other utilities: 
\code{\link{Anomaly}()},
\code{\link{Mag}()},
\code{\link{Percentile}()},
\code{\link{logic}}
}
\concept{utilities}
