% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_longitude.R
\name{scale_longitude}
\alias{scale_longitude}
\alias{scale_x_longitude}
\alias{scale_latitude}
\alias{scale_y_longitude}
\alias{scale_x_latitude}
\alias{scale_y_latitude}
\alias{scale_x_level}
\alias{scale_y_level}
\title{Helpful scales for maps}
\usage{
scale_x_longitude(name = "", ticks = 30, breaks = seq(-180, 360, by =
  ticks), expand = c(0, 0), labels = LonLabel, trans = "identity",
  ...)

scale_y_longitude(name = "", ticks = 60, breaks = seq(-180, 360, by =
  ticks), expand = c(0, 0), labels = LonLabel, trans = "identity",
  ...)

scale_x_latitude(name = "", ticks = 30, breaks = seq(-90, 90, by =
  ticks), expand = c(0, 0), labels = LatLabel, ...)

scale_y_latitude(name = "", ticks = 30, breaks = seq(-90, 90, by =
  ticks), expand = c(0, 0), labels = LatLabel, ...)

scale_x_level(name = "", expand = c(0, 0), trans = "reverselog", ...)

scale_y_level(name = "", expand = c(0, 0), trans = "reverselog", ...)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{ticks}{spacing between breaks}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
transformation object
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output
}}

\item{expand}{Vector of range expansion constants used to add some
padding around the data, to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[=expand_scale]{expand_scale()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}

\item{trans}{Either the name of a transformation object, or the
object itself. Built-in transformations include "asn", "atanh",
"boxcox", "exp", "identity", "log", "log10", "log1p", "log2",
"logit", "probability", "probit", "reciprocal", "reverse" and "sqrt".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \code{name_trans}, e.g.
\code{\link[scales:boxcox_trans]{scales::boxcox_trans()}}. You can create your own
transformation with \code{\link[scales:trans_new]{scales::trans_new()}}.}

\item{...}{Other arguments passed on to \code{scale_(x|y)_continuous()}}
}
\description{
These functions are simple wrappers around
\code{\link[ggplot2]{scale_x_continuous}} and
\code{\link[ggplot2]{scale_y_continuous}} with
helpful defaults for plotting longitude, latitude and pressure levels.
}
\examples{
data(geopotential)
library(ggplot2)
ggplot(geopotential[date == date[1]], aes(lon, lat, z = gh)) +
    geom_contour() +
    scale_x_longitude() +
    scale_y_latitude()

}
\seealso{
Other ggplot2 helpers: \code{\link{DivideTimeseries}},
  \code{\link{MakeBreaks}}, \code{\link{WrapCircular}},
  \code{\link{geom_arrow}}, \code{\link{geom_contour2}},
  \code{\link{geom_contour_fill}},
  \code{\link{geom_label_contour}},
  \code{\link{geom_relief}}, \code{\link{geom_streamline}},
  \code{\link{guide_colourstrip}},
  \code{\link{map_labels}}, \code{\link{reverselog_trans}},
  \code{\link{scale_divergent}}, \code{\link{stat_na}},
  \code{\link{stat_subset}}
}
\concept{ggplot2 helpers}
