% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_vector.R
\name{guide_vector}
\alias{guide_vector}
\title{Reference arrow for magnitude scales}
\usage{
guide_vector(
  title = ggplot2::waiver(),
  title.position = NULL,
  title.theme = NULL,
  title.hjust = NULL,
  title.vjust = NULL,
  label = TRUE,
  label.position = NULL,
  label.theme = NULL,
  label.hjust = NULL,
  label.vjust = NULL,
  keywidth = NULL,
  keyheight = NULL,
  direction = NULL,
  default.unit = "cm",
  override.aes = list(),
  nrow = NULL,
  ncol = NULL,
  byrow = FALSE,
  reverse = FALSE,
  order = 0,
  ...
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{title.position}{A character string indicating the position of a
title. One of "top" (default for a vertical guide), "bottom", "left"
(default for a horizontal guide), or "right."}

\item{title.theme}{A theme object for rendering the title text. Usually the
object of \code{\link[ggplot2:element_text]{element_text()}} is expected. By default, the theme is
specified by \code{legend.title} in \code{\link[ggplot2:theme]{theme()}} or theme.}

\item{title.hjust}{A number specifying horizontal justification of the
title text.}

\item{title.vjust}{A number specifying vertical justification of the title
text.}

\item{label}{logical. If \code{TRUE} then the labels are drawn. If
\code{FALSE} then the labels are invisible.}

\item{label.position}{A character string indicating the position of a
label. One of "top", "bottom" (default for horizontal guide), "left", or
"right" (default for vertical guide).}

\item{label.theme}{A theme object for rendering the label text. Usually the
object of \code{\link[ggplot2:element_text]{element_text()}} is expected. By default, the theme is
specified by \code{legend.text} in \code{\link[ggplot2:theme]{theme()}}.}

\item{label.hjust}{A numeric specifying horizontal justification of the
label text. The default for standard text is 0 (left-aligned) and 1
(right-aligned) for expressions.}

\item{label.vjust}{A numeric specifying vertical justification of the label
text.}

\item{keywidth}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the width of the legend key. Default value is \code{legend.key.width} or
\code{legend.key.size} in \code{\link[ggplot2:theme]{theme()}}.}

\item{keyheight}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the height of the legend key. Default value is \code{legend.key.height} or
\code{legend.key.size} in \code{\link[ggplot2:theme]{theme()}}.}

\item{direction}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}

\item{default.unit}{A character string indicating \code{\link[grid:unit]{grid::unit()}}
for \code{keywidth} and \code{keyheight}.}

\item{override.aes}{A list specifying aesthetic parameters of legend key.
See details and examples.}

\item{nrow}{The desired number of rows of legends.}

\item{ncol}{The desired number of column of legends.}

\item{byrow}{logical. If \code{FALSE} (the default) the legend-matrix is
filled by columns, otherwise the legend-matrix is filled by rows.}

\item{reverse}{logical. If \code{TRUE} the order of legends is reversed.}

\item{order}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}

\item{...}{ignored.}
}
\description{
Draws a reference arrow. Highly experimental.
}
\seealso{
scale_vector
}
