% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_vector.R
\name{scale_mag}
\alias{scale_mag}
\alias{scale_mag_continuous}
\title{Scale for vector magnitudes}
\usage{
scale_mag(
  name = ggplot2::waiver(),
  labels = ggplot2::waiver(),
  max_size = 1,
  default_unit = "cm",
  max = ggplot2::waiver(),
  guide = guide_vector(),
  ...
)

scale_mag_continuous(
  name = ggplot2::waiver(),
  labels = ggplot2::waiver(),
  max_size = 1,
  default_unit = "cm",
  max = ggplot2::waiver(),
  guide = guide_vector(),
  ...
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{max_size}{size of the arrow in centimetres}

\item{default_unit}{ignored}

\item{max}{magnitude of the reference arrow in data units. Will be the
maximum value if \code{waiver()}}

\item{guide}{type of legend}

\item{...}{Other arguments passed on to \verb{scale_(x|y)_continuous()}}
}
\description{
Allows to control the size of the arrows in \link{geom_arrow}.
Highly experimental.
}
\examples{
library(ggplot2)
g <- ggplot(seals, aes(long, lat)) +
    geom_vector(aes(dx = delta_long, dy = delta_lat), skip = 2)

g + scale_mag("Seals velocity")

g + scale_mag("Seals velocity", max = 1)

g + scale_mag("Seals velocity", max_size = 2)
g + scale_mag("Seals velocity", default_unit = "mm")
}
