#' Thiamethoxam applications in squash crops
#'
#' A dataset on the effect of the thiamethoxam application method and plant
#'   variety on bees.
#'
#' @format A data frame with 55 observations and 11 variables:
#' \describe{
#' \item{trt}{Treatment.}
#' \item{var}{Variety.}
#' \item{rep}{Replicate.}
#' \item{fruit}{Average fruit number per plant.}
#' \item{avg_mass}{Individual Fruit mass average (g).}
#' \item{mass}{Fruit mass per plant (g).}
#' \item{yield}{Yield (4 plants).}
#' \item{visit}{Bee visits per plot.}
#' \item{foliage}{Proportion of foliage consumed by striped cucumber beetle.}
#' \item{scb}{Striped cucumber beetle per plant.}
#' \item{defoliation}{Defoliation percentage.}
#' }
#' @usage data("thiamethoxam")
#' @examples
#' data("thiamethoxam")
#' thiamethoxam
#' @source Obregon D, Pederson G, Taylor A, Poveda K (2022). “The Pest Control
#'   and Pollinator Protection Dilemma: The Case of Thiamethoxam Prophylactic
#'   Applications in Squash Crops.” \emph{PLOS ONE}, 17(5), 1--18.
#'   \doi{10.1371/journal.pone.0267984}.
"thiamethoxam"
