% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/confreg-methods.R
\name{confreg}
\alias{confreg}
\alias{confreg,EL-method}
\title{Confidence region for model parameters}
\usage{
\S4method{confreg}{EL}(
  object,
  parm,
  level = 0.95,
  cv = qchisq(level, 2L),
  npoints = 50L,
  control = el_control()
)
}
\arguments{
\item{object}{A fitted \linkS4class{EL} object.}

\item{parm}{A specification of which parameters are to be given a confidence
region, either a vector of numbers or a vector of names. It should be a
vector of length two of the form \code{c(x, y)}. If missing, the first two
parameter in \code{object} are considered.}

\item{level}{A confidence level required. Defaults to \code{0.95}.}

\item{cv}{A critical value for calibration of empirical likelihood ratio
statistic. Defaults to \code{qchisq(level, 2L)}.}

\item{npoints}{The number of boundary points to compute. Defaults to
\code{50}.}

\item{control}{A list of control parameters set by \code{\link{el_control}}.}
}
\value{
An object of class \linkS4class{ConfregEL}.
}
\description{
Computes boundary points of a two-dimensional confidence region for model
  parameters.
}
\examples{
par <- c(0, 0, 0)
x <- matrix(rnorm(90), ncol = 3)
fit <- el_mean(par, x)
confreg(fit, parm = c(1, 3))
}
\references{
Owen, Art. 1990. “Empirical Likelihood Ratio Confidence Regions.”
  The Annals of Statistics 18 (1): 90–120. \doi{10.1214/aos/1176347494}.
}
\seealso{
\link{confint}, \link{el_control}, \link{lht}, \link{plot}
}
