% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{light_advanced}
\alias{light_advanced}
\alias{light_leafAngleCDF}
\alias{light_leafAngleBetaParameters}
\alias{light_directionalExtinctionCoefficient}
\alias{light_layerDirectIrradianceFraction}
\alias{light_layerDiffuseIrradianceFraction}
\alias{light_cohortSunlitShadeAbsorbedRadiation}
\alias{light_layerSunlitFraction}
\alias{light_instantaneousLightExtinctionAbsortion}
\alias{light_longwaveRadiationSHAW}
\title{Advanced radiation transfer functions}
\usage{
light_leafAngleCDF(leafAngle, p, q)

light_leafAngleBetaParameters(leafAngle, leafAngleSD)

light_directionalExtinctionCoefficient(p, q, solarElevation)

light_layerDirectIrradianceFraction(
  LAIme,
  LAImd,
  LAImx,
  kb,
  ClumpingIndex,
  alpha,
  gamma,
  trunkExtinctionFraction = 0.1
)

light_layerDiffuseIrradianceFraction(
  LAIme,
  LAImd,
  LAImx,
  K,
  ClumpingIndex,
  ZF,
  alpha,
  gamma,
  trunkExtinctionFraction = 0.1
)

light_cohortSunlitShadeAbsorbedRadiation(
  Ib0,
  Id0,
  LAIme,
  LAImd,
  LAImx,
  kb,
  K,
  ClumpingIndex,
  ZF,
  alpha,
  gamma,
  trunkExtinctionFraction = 0.1
)

light_layerSunlitFraction(LAIme, LAImd, kb, ClumpingIndex)

light_instantaneousLightExtinctionAbsortion(
  LAIme,
  LAImd,
  LAImx,
  p,
  q,
  ClumpingIndex,
  alphaSWR,
  gammaSWR,
  ddd,
  ntimesteps = 24L,
  trunkExtinctionFraction = 0.1
)

light_longwaveRadiationSHAW(
  LAIme,
  LAImd,
  LAImx,
  LWRatm,
  Tsoil,
  Tair,
  trunkExtinctionFraction = 0.1
)
}
\arguments{
\item{leafAngle}{Average leaf inclination angle (in radians).}

\item{p, q}{Parameters of the beta distribution for leaf angles}

\item{leafAngleSD}{Standard deviation of leaf inclination angle (in radians).}

\item{solarElevation}{Solar elevation (in radians).}

\item{LAIme}{A numeric matrix of live expanded LAI values per vegetation layer (row) and cohort (column).}

\item{LAImd}{A numeric matrix of dead LAI values per vegetation layer (row) and cohort (column).}

\item{LAImx}{A numeric matrix of maximum LAI values per vegetation layer (row) and cohort (column).}

\item{kb}{A vector of direct light extinction coefficients.}

\item{ClumpingIndex}{The extent to which foliage has a nonrandom spatial distribution.}

\item{alpha}{A vector of leaf absorbance by species.}

\item{gamma}{A vector of leaf reflectance values.}

\item{trunkExtinctionFraction}{Fraction of extinction due to trunks (for winter deciduous forests).}

\item{K}{A vector of light extinction coefficients.}

\item{ZF}{Fraction of sky angles.}

\item{Ib0}{Above-canopy direct incident radiation.}

\item{Id0}{Above-canopy diffuse incident radiation.}

\item{alphaSWR}{A vecfor of hort-wave absorbance coefficients for each cohort.}

\item{gammaSWR}{A vector of short-wave reflectance coefficients (albedo) for each cohort.}

\item{ddd}{A dataframe with direct and diffuse radiation for different subdaily time steps (see function \code{radiation_directDiffuseDay} in package meteoland).}

\item{ntimesteps}{Number of subdaily time steps.}

\item{LWRatm}{Atmospheric downward long-wave radiation (W/m2).}

\item{Tsoil}{Soil temperature (Celsius).}

\item{Tair}{Canopy layer air temperature vector (Celsius).}
}
\value{
Functions \code{light_layerDirectIrradianceFraction}, \code{light_layerDiffuseIrradianceFraction}
and \code{light_layerSunlitFraction} return a numeric vector of length equal to the number of vegetation layers. 

Function \code{light_cohortSunlitShadeAbsorbedRadiation} returns a list with 
two elements (matrices): \code{I_sunlit} and \code{I_shade}.
}
\description{
Functions \code{light_layerDirectIrradianceFraction} and \code{light_layerDiffuseIrradianceFraction} calculate 
the fraction of above-canopy direct and diffuse radiation reaching each vegetation layer. 
Function \code{light_layerSunlitFraction} calculates the proportion of sunlit leaves in each vegetation layer. 
Function \code{light_cohortSunlitShadeAbsorbedRadiation} calculates the amount of radiation absorbed 
by cohort and vegetation layers, while differentiating between sunlit and shade leaves.
}
\details{
Functions for short-wave radiation are adapted from Anten & Bastiaans (2016), 
whereas long-wave radiation balance follows Flerchinger et al. (2009). 
Vegetation layers are assumed to be ordered from bottom to top.
}
\examples{
solarElevation <- 0.67 # in radians
SWR_direct <- 1100
SWR_diffuse <- 300
PAR_direct <- 550
PAR_diffuse <- 150

LAI <- 2
nlayer <- 10
LAIlayerlive <- matrix(rep(LAI/nlayer,nlayer),nlayer,1)
LAIlayerdead <- matrix(0,nlayer,1)
meanLeafAngle <- 60 # in degrees
sdLeafAngle <- 20

beta <- light_leafAngleBetaParameters(meanLeafAngle*(pi/180), sdLeafAngle*(pi/180))

## Extinction coefficients
kb <- light_directionalExtinctionCoefficient(beta["p"], beta["q"], solarElevation)
kd_PAR <- 0.5
kd_SWR <- kd_PAR/1.35
}
\references{
Anten, N.P.R., Bastiaans, L., 2016. The use of canopy models to analyze light competition among plants, in: Hikosaka, K., Niinemets, U., Anten, N.P.R. (Eds.), Canopy Photosynthesis: From Basics to Application. Springer, pp. 379–398.

Flerchinger, G. N., Xiao, W., Sauer, T. J., Yu, Q. 2009. Simulation of within-canopy radiation exchange. NJAS - Wageningen Journal of Life Sciences 57 (1): 5–15. https://doi.org/10.1016/j.njas.2009.07.004.
}
\seealso{
\code{\link{spwb}}, \code{\link{light_basic}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
\keyword{internal}
