% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_binaryclass.R
\name{Brier}
\alias{Brier}
\title{Brier score}
\usage{
Brier(probabilities, truth, negative, positive)
}
\arguments{
\item{probabilities}{[numeric] vector of predicted probabilities}

\item{truth}{vector of true values}

\item{negative}{negative class}

\item{positive}{positive class}
}
\description{
The Brier score is defined as the quadratic difference between the probability and the value (1,0) for the class.
That means we use the numeric representation 1 and 0 for our target classes. It is similiar to the mean squared error in regression.
multiclass.brier is the sum over all one vs. all comparisons and for a binary classifcation 2 * brier.
}
\examples{
n = 20
set.seed(125)
truth = as.factor(sample(c(1,0), n, replace = TRUE))
probabilities = runif(n)
response = as.factor(as.numeric(probabilities > 0.5))
positive = 1
negative = 0
Brier(probabilities, truth, negative, positive)
}
