% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CIACountries}
\alias{CIACountries}
\title{Several variables on countries from the CIA Factbook, 2014.}
\format{A data frame with the following variables for each of the Countries
in the World. (236 countries are given.)
\describe{
\item{country}{Name of the country} 
\item{pop}{number of people, 2119}
\item{area}{area (sq km), 2147} 
\item{oil_prod}{Crude oil - production (bbl/day), 2241}
\item{gdp}{Gross Domestic Product per capita ($/person), 2001}
\item{educ}{education spending (\% of GDP), 2206}
\item{roadways}{Roadways per unit area (km/sq km), 2085}
\item{net_users}{Fraction of Internet users (\% of population), 2153}
}}
\source{
From the CIA World Factbook,
\url{https://www.cia.gov/library/publications/the-world-factbook/}
}
\usage{
CIACountries
}
\description{
The CIA Factbook has geographic, demographic, and economic data on a
country-by-country basis.
In the description of the variables, the 4-digit
number indicates the code used to specify that variable on the data and
documentation web site.
For instance,
\url{https://www.cia.gov/library/publications/the-world-factbook/fields/2153.html}
contains documentation for variable code 2153, network users.
}
\examples{

data(CIACountries)
glimpse(CIACountries)

}
\references{
\url{https://github.com/factbook/factbook/blob/master/data/categories.csv}
}
\seealso{
\code{\link[mosaic]{CIAdata}}
}
\keyword{datasets}
