% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicater.R
\name{replicater}
\alias{replicater}
\title{Replicate expressions with progress reporting}
\usage{
replicater(n, expr, show_progress = TRUE)
}
\arguments{
\item{n}{An integer specifying the number of times the expression should be replicated.}

\item{expr}{The expression to be evaluated. This can be any valid R expression. Note that
the expression is evaluated in the environment from which `replicater` is called.}

\item{show_progress}{Logical, indicating whether to show progress and ETA information.
Defaults to `TRUE`.}
}
\value{
A list of length `n` containing the results of each evaluation of `expr`.
}
\description{
Executes an R expression `n` times in a loop, optionally displaying progress and estimated time
until completion. This function is particularly useful for simulations where
the progress of repetitive tasks is beneficial for monitoring execution time and estimating
completion. Progress information includes the percentage completed and an estimated time of
arrival (ETA) calculated based on the average time per iteration.
}
\examples{
# Simple example without progress (for quick execution)
results <- replicater(5, rnorm(1), show_progress = FALSE)

# Example with progress - might take longer due to Sys.sleep()
results_with_delay <- replicater(10, {Sys.sleep(0.2); rnorm(1)}, show_progress = TRUE)
}
