% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_formula.R
\encoding{UTF-8}
\name{get_all_formulas}
\alias{get_all_formulas}
\title{Call \code{get_formula_str} for multiple ytypes and paste strings}
\usage{
get_all_formulas(ST, prior, par_x, ytypes = c("ct", "sigma", "arma"))
}
\arguments{
\item{ST}{Tibble. Returned by \code{get_segment_table}.}

\item{prior}{Named list. Names are parameter names (\code{cp_i}, \code{int_i}, \code{xvar_i},
`sigma``) and the values are either
\itemize{
\item A JAGS distribution (e.g., \code{int_1 = "dnorm(0, 1) T(0,)"}) indicating a
conventional prior distribution. Uninformative priors based on data
properties are used where priors are not specified. This ensures good
parameter estimations, but it is a questionable for hypothesis testing.
\code{mcp} uses SD (not precision) for dnorm, dt, dlogis, etc. See
details. Change points are forced to be ordered through the priors using
truncation, except for uniform priors where the lower bound should be
greater than the previous change point, \code{dunif(cp_1, MAXX)}.
\item A numerical value (e.g., \code{int_1 = -2.1}) indicating a fixed value.
\item A model parameter name (e.g., \code{int_2 = "int_1"}), indicating that this parameter is shared -
typically between segments. If two varying effects are shared this way,
they will need to have the same grouping variable.
\item A scaled Dirichlet prior is supported for change points if they are all set to
\verb{cp_i = "dirichlet(N)} where \code{N} is the alpha for this change point and
\code{N = 1} is most often used. This prior is less informative about the
location of the change points than the default uniform prior, but it
samples less efficiently, so you will often need to set \code{iter} higher.
It is recommended for hypothesis testing and for the estimation of more
than 5 change points. \href{https://lindeloev.github.io/mcp/articles/priors.html}{Read more}.
}}

\item{par_x}{String (default: NULL). Only relevant if no segments contains
slope (no hint at what x is). Set this, e.g., par_x = "time".}

\item{ytypes}{A character vector of ytypes to including in model building}
}
\value{
A string with JAGS code.
}
\description{
Currently used to differentiate between the JAGS model (use all) and the
fit$simulate model (do not include arma).
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
\keyword{internal}
