% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pars.R
\name{pars.mcmcr}
\alias{pars.mcmcr}
\title{Parameter Names}
\usage{
\method{pars}{mcmcr}(x, scalar = NULL, terms = FALSE, ...)
}
\arguments{
\item{x}{An object.}

\item{scalar}{A logical scalar specifying whether to include
all parameters (NULL), only scalars (TRUE) or all parameters
except scalars (FALSE).}

\item{terms}{A logical scalar specifying whether to provide the parameters for each term.}

\item{...}{Other arguments passed to methods.}
}
\value{
A character vector of the names of the parameters.
}
\description{
Gets the parameter names.
}
\examples{
\dontshow{if (requireNamespace("nlist", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(nlist)

pars(nlist(zz = 1, y = 3:6))
\dontshow{\}) # examplesIf}
}
\seealso{
Other parameters: 
\code{\link[universals]{npars}()},
\code{\link[universals]{set_pars}()}
}
