% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_sic_covariance.R
\name{mc_sic_covariance}
\alias{mc_sic_covariance}
\title{Score Information Criterion - Covariance}
\source{
Bonat, et. al. (2016). Modelling the covariance structure in
marginal multivariate count models: Hunting in Bioko Island.
Journal of Agricultural Biological and Environmental Statistics, 22(4):446--464.

Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
mc_sic_covariance(object, scope, idx, data, penalty = 2, response)
}
\arguments{
\item{object}{an object of \code{mcglm} class.}

\item{scope}{a list of matrices to be tested.}

\item{idx}{indicator of matrices belong to the same effect.
It is useful for the case where more than one matrix represents
the same effect.}

\item{data}{data set containing all variables involved in the
model.}

\item{penalty}{penalty term (default = 2).}

\item{response}{index indicating for which response variable
SIC-covariance should be computed.}
}
\value{
A data frame containing SIC-covariance values,
degree of freedom, Tu-statistics and chi-squared reference values
for each matrix in the scope argument.
}
\description{
Compute the score information criterion (SIC) for an
object of \code{mcglm} class. The SIC-covariance is useful for
selecting the components of the matrix linear predictor. It can be
used to construct an stepwise procedure to select the components of
the matrix linear predictor.
}
\examples{
set.seed(123)
SUBJECT <- gl(10, 10)
y <- rnorm(100)
data <- data.frame(y, SUBJECT)
Z0 <- mc_id(data)
Z1 <- mc_mixed(~0+SUBJECT, data = data)
# Reference model
fit0 <- mcglm(c(y ~ 1), list(Z0), data = data)
# Testing the effect of the matrix Z1
mc_sic_covariance(fit0, scope = Z1, idx = 1,
data = data, response = 1)
# As expected Tu < Chisq indicating non-significance of Z1 matrix
}
\seealso{
\code{mc_sic}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
