% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oplibrary.R
\name{byte_mutation_dynamic}
\alias{byte_mutation_dynamic}
\title{Performs mutation operation on a given double vector using dynamic mutation probabilities}
\usage{
byte_mutation_dynamic(object, parent, ...)
}
\arguments{
\item{object}{A \code{GA::ga} object}

\item{parent}{Index of the candidate solution of the current population}

\item{...}{Additional arguments to be passed to the function}
}
\value{
Mutated double vector
}
\description{
This function is not called directly but is given as a parameter in \code{GA::ga} function. 
In \code{GA::ga}, if the parameter \code{mutation=} is set to \code{byte_mutation_dynamic} than
the byte-coded mutation operator is applied in the genetic search. In \code{mcga2} function, the hard-coded 
mutation parameter is set to byte_mutation by definition. Byte-mutation function simply takes an double vector and
changes bytes of this values by +1 or -1 using the dynamically decreased and pre-determined mutation probabilty.
}
\examples{
f <- function(x){ 
  return(-sum( (x-5)^2 ) )
}
myga <- GA::ga(type="real-valued", fitness = f, popSize = 100, maxiter = 200, 
              min = rep(-50,5), max = rep(50,5), crossover = byte_crossover,
              mutation = byte_mutation_dynamic, pmutation = 0.10)
print(myga@solution)
}
\author{
Mehmet Hakan Satman - mhsatman@istanbul.edu.tr
}
\references{
M.H.Satman (2013), Machine Coded Genetic Algorithms for Real Parameter Optimization Problems, Gazi University Journal of Science, Vol 26, No 1, pp. 85-95
}

