% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcen.r
\name{coef.cv.mcen}
\alias{coef.cv.mcen}
\title{Returns the coefficients from the cv.mcen object with the smallest cross-validation error.}
\usage{
\method{coef}{cv.mcen}(object, ...)
}
\arguments{
\item{object}{The cv.mcen object.}

\item{...}{Additional values to be passed.}
}
\value{
The matrix of coefficients for the best MCEN model as determined by cross-validation.
}
\description{
Returns the coefficients from the cv.mcen object with the smallest cross-validation error.
}
\examples{
\donttest{
x <- matrix(rnorm(400),ncol=4)
beta <- beta <- matrix(c(1,1,0,0,0,0,-1,-1,0,0,-1,-1,1,1,0,0),ncol=4)
y <- x\%*\%beta + rnorm(400) 
mcen_fit <- cv.mcen(x,y,ky=2,gamma_y=3)
best_coef <- coefficients(mcen_fit)
}
}
\author{
Ben Sherwood <ben.sherwood@ku.edu>, Brad Price <brad.price@mail.wvu.edu>
}
