% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcen.r
\name{mcen}
\alias{mcen}
\title{Fits an MCEN model}
\usage{
mcen(x, y, family = "mgaussian", ky = NULL, delta = NULL, gamma_y = 1,
  ndelta = 25, delta.min.ratio = NULL, eps = 1e-05,
  scale_x = TRUE, scale_y = TRUE, clusterMethod = "kmeans",
  clusterStartNum = 30, clusterIterations = 10, cluster_y = NULL,
  max_iter = 10, init_beta = NULL, n.cores = 1)
}
\arguments{
\item{x}{Matrix of predictors.}

\item{y}{Matrix of responses.}

\item{family}{Type of likelihood used two options "mgaussian" or "mbinomial".}

\item{ky}{Clusters for response.}

\item{delta}{L1 penalty.}

\item{gamma_y}{Penalty for with y clusters difference in predicted values.}

\item{ndelta}{Number of delta parameters.}

\item{delta.min.ratio}{Ratio between smallest and largest delta.}

\item{eps}{Convergence criteria.}

\item{scale_x}{Whether x matrix should be scaled, default is True.}

\item{scale_y}{Whether y matrix should be scaled, default is True.}

\item{clusterMethod}{K-means function used kmeans or kmeanspp.}

\item{clusterStartNum}{Number of random starting points for clustering.}

\item{clusterIterations}{Number of iterations for cluster convergence.}

\item{cluster_y}{An a priori definition of clusters. If clusters are provided they will remain fixed and are not estimated. Objective function is then convex.}

\item{max_iter}{Maximum number of iterations for coefficient estimates.}

\item{init_beta}{Clustering step requires an initial estimate, default is to use elastic net solution.}

\item{n.cores}{Number of cores used for calculation default is 1.}
}
\value{
returns a MCEN object
\item{beta}{List of the coefficient estimates.}
\item{delta}{Value of delta.}
\item{gamma_y}{Value of gamma_y.}
\item{ky}{Value of ky.} 
\item{y_clusters}{List of the clusters of y.}
}
\description{
Fits an MCEN model
}
\examples{
x <- matrix(rnorm(400),ncol=4)
beta <- beta <- matrix(c(1,1,0,0,0,0,-1,-1,0,0,-1,-1,1,1,0,0),ncol=4)
y <- x\%*\%beta + rnorm(400) 
mcen_fit <- mcen(x,y,ky=2,delta=1)
}
\references{
Price, B.S. and Sherwood, B. (2018). A Cluster Elastic Net for Multivariate Regression. arXiv preprint arXiv:1707.03530. \url{http://arxiv-export-lb.library.cornell.edu/abs/1707.03530}.
}
\author{
Ben Sherwood <ben.sherwood@ku.edu>, Brad Price <brad.price@mail.wvu.edu>
}
