% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcen.r
\name{predict.mcen}
\alias{predict.mcen}
\title{predictions from a mcen model}
\usage{
\method{predict}{mcen}(object, newx, ...)
}
\arguments{
\item{object}{The mcen object.}

\item{newx}{A matrix of new observations.}

\item{...}{Additional variables to be sent to predict.}
}
\value{
Returns predictions for each beta of an mcen object
}
\description{
predictions from a mcen model
}
\examples{
x <- matrix(rnorm(400),ncol=4)
beta <- beta <- matrix(c(1,1,0,0,0,0,-1,-1,0,0,-1,-1,1,1,0,0),ncol=4)
y <- x\%*\%beta + rnorm(400) 
mcen_fit <- mcen(x,y,ky=2,delta=1)
new_x <- matrix(rnorm(12),ncol=4)
mcen_preds <- predict(mcen_fit, new_x)
}
\author{
Ben Sherwood <ben.sherwood@ku.edu>, Brad Price <brad.price@mail.wvu.edu>
}
