% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmcd.R
\name{rmcd}
\alias{rmcd}
\title{Simulate from a Multivariate Cauchy Distribution}
\usage{
rmcd(n, mu, Sigma, tol = 1e-6)
}
\arguments{
\item{n}{integer. Number of observations.}

\item{mu}{length \eqn{p} numeric vector. The location parameter.}

\item{Sigma}{symmetric, positive-definite square matrix of order \eqn{p}. The scatter matrix.}

\item{tol}{tolerance for numerical lack of positive-definiteness in Sigma (for \code{mvrnorm}, see Details).}
}
\value{
A matrix with \eqn{p} columns and \eqn{n} rows.
}
\description{
Produces one or more samples from the multivariate (\eqn{p} variables) Cauchy distribution (MCD)
with location parameter \code{mu} and scatter matrix \code{Sigma}.
}
\details{
A sample from a MCD with parameters \eqn{\boldsymbol{\mu}} and \eqn{\Sigma}
can be generated using:
\deqn{\displaystyle{\mathbf{X} = \boldsymbol{\mu} + \frac{\mathbf{Y}}{\sqrt{u}}}}
where \eqn{\mathbf{Y}} is a random vector distributed among a centered Gaussian density
with covariance matrix \eqn{\Sigma} (generated using \code{\link{mvrnorm}})
and \eqn{u} is distributed among a Chi-squared distribution with 1 degree of freedom.
}
\examples{
mu <- c(0, 1, 4)
sigma <- matrix(c(1, 0.6, 0.2, 0.6, 1, 0.3, 0.2, 0.3, 1), nrow = 3)
x <- rmcd(100, mu, sigma)
x
apply(x, 2, median)

}
\seealso{
\code{\link{dmcd}}: probability density of a MCD.
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
