% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mbox.R
\name{read_mbox}
\alias{read_mbox}
\title{Converting an mbox file into a tibble data_frame.}
\usage{
read_mbox(mbox = NULL, file = NULL)
}
\arguments{
\item{mbox}{Input mbox file.}

\item{file}{Output RDS file if you want to save. The default is NULL, which is not saving the output as a file.}
}
\value{
Tibble object for the input mbox file will be returned.
}
\description{
Use this function for importing and converting an mbox file into a tibble object.
}
\details{
read_mbox


See example below.
}
\examples{
\donttest{
# Changing working directory to temp for the demonstration purpose only.
setwd(tempdir())
library(mboxr)
# Feeding an mbox file through read_mbox function:
test <- system.file("extdata", "test1.mbox", package = "mboxr")
data <- read_mbox(mbox = test, file = "output.rds")
# Now you can use the imported file as a tibble.
str(data)
}
}
\references{
\url{https://en.wikipedia.org/wiki/Mbox}

\url{https://docs.python.org/3/library/mailbox.html}

\url{https://www.anaconda.com/download/}
}
\author{
JooYoung Seo, \email{jooyoung@psu.edu}

Soyoung Choi, \email{sxc940@psu.edu}
}
\keyword{read_mbox}
